% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xray_operations.R
\name{xray_get_service_graph}
\alias{xray_get_service_graph}
\title{Retrieves a document that describes services that process incoming
requests, and downstream services that they call as a result}
\usage{
xray_get_service_graph(
  StartTime,
  EndTime,
  GroupName = NULL,
  GroupARN = NULL,
  NextToken = NULL
)
}
\arguments{
\item{StartTime}{[required] The start of the time frame for which to generate a graph.}

\item{EndTime}{[required] The end of the timeframe for which to generate a graph.}

\item{GroupName}{The name of a group based on which you want to generate a graph.}

\item{GroupARN}{The Amazon Resource Name (ARN) of a group based on which you want to
generate a graph.}

\item{NextToken}{Pagination token.}
}
\description{
Retrieves a document that describes services that process incoming requests, and downstream services that they call as a result. Root services process incoming requests and make calls to downstream services. Root services are applications that use the \href{https://docs.aws.amazon.com/xray/index.html}{Amazon Web Services X-Ray SDK}. Downstream services can be other applications, Amazon Web Services resources, HTTP web APIs, or SQL databases.

See \url{https://paws-r.github.io/docs/xray/get_service_graph.html} for full documentation.
}
\keyword{internal}
