% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_create_deployment_config}
\alias{codedeploy_create_deployment_config}
\title{Creates a deployment configuration}
\usage{
codedeploy_create_deployment_config(
  deploymentConfigName,
  minimumHealthyHosts = NULL,
  trafficRoutingConfig = NULL,
  computePlatform = NULL
)
}
\arguments{
\item{deploymentConfigName}{[required] The name of the deployment configuration to create.}

\item{minimumHealthyHosts}{The minimum number of healthy instances that should be available at any
time during the deployment. There are two parameters expected in the
input: type and value.

The type parameter takes either of the following values:
\itemize{
\item HOST_COUNT: The value parameter represents the minimum number of
healthy instances as an absolute value.
\item FLEET_PERCENT: The value parameter represents the minimum number of
healthy instances as a percentage of the total number of instances
in the deployment. If you specify FLEET_PERCENT, at the start of the
deployment, CodeDeploy converts the percentage to the equivalent
number of instances and rounds up fractional instances.
}

The value parameter takes an integer.

For example, to set a minimum of 95\% healthy instance, specify a type of
FLEET_PERCENT and a value of 95.}

\item{trafficRoutingConfig}{The configuration that specifies how the deployment traffic is routed.}

\item{computePlatform}{The destination platform type for the deployment (\code{Lambda}, \code{Server}, or
\code{ECS}).}
}
\description{
Creates a deployment configuration.

See \url{https://www.paws-r-sdk.com/docs/codedeploy_create_deployment_config/} for full documentation.
}
\keyword{internal}
