% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xray_operations.R
\name{xray_get_time_series_service_statistics}
\alias{xray_get_time_series_service_statistics}
\title{Get an aggregation of service statistics defined by a specific time
range}
\usage{
xray_get_time_series_service_statistics(
  StartTime,
  EndTime,
  GroupName = NULL,
  GroupARN = NULL,
  EntitySelectorExpression = NULL,
  Period = NULL,
  ForecastStatistics = NULL,
  NextToken = NULL
)
}
\arguments{
\item{StartTime}{[required] The start of the time frame for which to aggregate statistics.}

\item{EndTime}{[required] The end of the time frame for which to aggregate statistics.}

\item{GroupName}{The case-sensitive name of the group for which to pull statistics from.}

\item{GroupARN}{The Amazon Resource Name (ARN) of the group for which to pull statistics
from.}

\item{EntitySelectorExpression}{A filter expression defining entities that will be aggregated for
statistics. Supports ID, service, and edge functions. If no selector
expression is specified, edge statistics are returned.}

\item{Period}{Aggregation period in seconds.}

\item{ForecastStatistics}{The forecasted high and low fault count values. Forecast enabled
requests require the EntitySelectorExpression ID be provided.}

\item{NextToken}{Pagination token.}
}
\description{
Get an aggregation of service statistics defined by a specific time range.

See \url{https://www.paws-r-sdk.com/docs/xray_get_time_series_service_statistics/} for full documentation.
}
\keyword{internal}
