% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_list_fleets}
\alias{codebuild_list_fleets}
\title{Gets a list of compute fleet names with each compute fleet name
representing a single compute fleet}
\usage{
codebuild_list_fleets(
  nextToken = NULL,
  maxResults = NULL,
  sortOrder = NULL,
  sortBy = NULL
)
}
\arguments{
\item{nextToken}{During a previous call, if there are more than 100 items in the list,
only the first 100 items are returned, along with a unique string called
a \emph{nextToken}. To get the next batch of items in the list, call this
operation again, adding the next token to the call. To get all of the
items in the list, keep calling this operation with each subsequent next
token that is returned, until no more next tokens are returned.}

\item{maxResults}{The maximum number of paginated compute fleets returned per response.
Use \code{nextToken} to iterate pages in the list of returned compute fleets.}

\item{sortOrder}{The order in which to list compute fleets. Valid values include:
\itemize{
\item \code{ASCENDING}: List in ascending order.
\item \code{DESCENDING}: List in descending order.
}

Use \code{sortBy} to specify the criterion to be used to list compute fleet
names.}

\item{sortBy}{The criterion to be used to list compute fleet names. Valid values
include:
\itemize{
\item \code{CREATED_TIME}: List based on when each compute fleet was created.
\item \code{LAST_MODIFIED_TIME}: List based on when information about each
compute fleet was last changed.
\item \code{NAME}: List based on each compute fleet's name.
}

Use \code{sortOrder} to specify in what order to list the compute fleet names
based on the preceding criteria.}
}
\description{
Gets a list of compute fleet names with each compute fleet name representing a single compute fleet.

See \url{https://www.paws-r-sdk.com/docs/codebuild_list_fleets/} for full documentation.
}
\keyword{internal}
