% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_get_action_type}
\alias{codepipeline_get_action_type}
\title{Returns information about an action type created for an external
provider, where the action is to be used by customers of the external
provider}
\usage{
codepipeline_get_action_type(category, owner, provider, version)
}
\arguments{
\item{category}{[required] Defines what kind of action can be taken in the stage. The following are
the valid values:
\itemize{
\item \code{Source}
\item \code{Build}
\item \code{Test}
\item \code{Deploy}
\item \code{Approval}
\item \code{Invoke}
\item \code{Compute}
}}

\item{owner}{[required] The creator of an action type that was created with any supported
integration model. There are two valid values: \code{AWS} and \code{ThirdParty}.}

\item{provider}{[required] The provider of the action type being called. The provider name is
specified when the action type is created.}

\item{version}{[required] A string that describes the action type version.}
}
\description{
Returns information about an action type created for an external provider, where the action is to be used by customers of the external provider. The action can be created with any supported integration model.

See \url{https://www.paws-r-sdk.com/docs/codepipeline_get_action_type/} for full documentation.
}
\keyword{internal}
