% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wellarchitected_operations.R
\name{wellarchitected_update_workload}
\alias{wellarchitected_update_workload}
\title{Update an existing workload}
\usage{
wellarchitected_update_workload(
  WorkloadId,
  WorkloadName = NULL,
  Description = NULL,
  Environment = NULL,
  AccountIds = NULL,
  AwsRegions = NULL,
  NonAwsRegions = NULL,
  PillarPriorities = NULL,
  ArchitecturalDesign = NULL,
  ReviewOwner = NULL,
  IsReviewOwnerUpdateAcknowledged = NULL,
  IndustryType = NULL,
  Industry = NULL,
  Notes = NULL,
  ImprovementStatus = NULL,
  DiscoveryConfig = NULL,
  Applications = NULL,
  JiraConfiguration = NULL
)
}
\arguments{
\item{WorkloadId}{[required]}

\item{WorkloadName}{}

\item{Description}{}

\item{Environment}{}

\item{AccountIds}{}

\item{AwsRegions}{}

\item{NonAwsRegions}{}

\item{PillarPriorities}{}

\item{ArchitecturalDesign}{}

\item{ReviewOwner}{}

\item{IsReviewOwnerUpdateAcknowledged}{Flag indicating whether the workload owner has acknowledged that the
\emph{Review owner} field is required.

If a \strong{Review owner} is not added to the workload within 60 days of
acknowledgement, access to the workload is restricted until an owner is
added.}

\item{IndustryType}{}

\item{Industry}{}

\item{Notes}{}

\item{ImprovementStatus}{}

\item{DiscoveryConfig}{Well-Architected discovery configuration settings to associate to the
workload.}

\item{Applications}{List of AppRegistry application ARNs to associate to the workload.}

\item{JiraConfiguration}{Configuration of the Jira integration.}
}
\description{
Update an existing workload.

See \url{https://www.paws-r-sdk.com/docs/wellarchitected_update_workload/} for full documentation.
}
\keyword{internal}
