% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_create_user}
\alias{appstream_create_user}
\title{Creates a new user in the user pool}
\usage{
appstream_create_user(UserName, MessageAction, FirstName, LastName,
  AuthenticationType)
}
\arguments{
\item{UserName}{[required] The email address of the user.

Users' email addresses are case-sensitive. During login, if they specify
an email address that doesn't use the same capitalization as the email
address specified when their user pool account was created, a "user does
not exist" error message displays.}

\item{MessageAction}{The action to take for the welcome email that is sent to a user after
the user is created in the user pool. If you specify SUPPRESS, no email
is sent. If you specify RESEND, do not specify the first name or last
name of the user. If the value is null, the email is sent.

The temporary password in the welcome email is valid for only 7 days. If
users don’t set their passwords within 7 days, you must send them a new
welcome email.}

\item{FirstName}{The first name, or given name, of the user.}

\item{LastName}{The last name, or surname, of the user.}

\item{AuthenticationType}{[required] The authentication type for the user. You must specify USERPOOL.}
}
\value{
An empty list.
}
\description{
Creates a new user in the user pool.
}
\section{Request syntax}{
\preformatted{svc$create_user(
  UserName = "string",
  MessageAction = "SUPPRESS"|"RESEND",
  FirstName = "string",
  LastName = "string",
  AuthenticationType = "API"|"SAML"|"USERPOOL"
)
}
}

\keyword{internal}
