% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_migrate_workspace}
\alias{workspaces_migrate_workspace}
\title{Migrates a WorkSpace from one operating system or bundle type to
another, while retaining the data on the user volume}
\usage{
workspaces_migrate_workspace(SourceWorkspaceId, BundleId)
}
\arguments{
\item{SourceWorkspaceId}{[required] The identifier of the WorkSpace to migrate from.}

\item{BundleId}{[required] The identifier of the target bundle type to migrate the WorkSpace to.}
}
\value{
A list with the following syntax:\preformatted{list(
  SourceWorkspaceId = "string",
  TargetWorkspaceId = "string"
)
}
}
\description{
Migrates a WorkSpace from one operating system or bundle type to
another, while retaining the data on the user volume.

The migration process recreates the WorkSpace by using a new root volume
from the target bundle image and the user volume from the last available
snapshot of the original WorkSpace. During migration, the original
\verb{D:\\Users\%USERNAME\%} user profile folder is renamed to
\verb{D:\\Users\%USERNAME\%MMddyyTHHmmss\%.NotMigrated}. A new
\verb{D:\\Users\%USERNAME\%\\} folder is generated by the new OS. Certain files
in the old user profile are moved to the new user profile.

For available migration scenarios, details about what happens during
migration, and best practices, see \href{https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html}{Migrate a WorkSpace}.
}
\section{Request syntax}{
\preformatted{svc$migrate_workspace(
  SourceWorkspaceId = "string",
  BundleId = "string"
)
}
}

\keyword{internal}
