% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_list_groups_for_entity}
\alias{workmail_list_groups_for_entity}
\title{Returns all the groups to which an entity belongs}
\usage{
workmail_list_groups_for_entity(
  OrganizationId,
  EntityId,
  Filters = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{OrganizationId}{[required] The identifier for the organization under which the entity exists.}

\item{EntityId}{[required] The identifier for the entity.

The entity ID can accept \emph{UserId or GroupID}, \emph{Username or Groupname},
or \emph{email}.
\itemize{
\item Entity ID: 12345678-1234-1234-1234-123456789012 or
S-1-1-12-1234567890-123456789-123456789-1234
\item Email address: entity@domain.tld
\item Entity name: entity
}}

\item{Filters}{Limit the search results based on the filter criteria.}

\item{NextToken}{The token to use to retrieve the next page of results. The first call
does not contain any tokens.}

\item{MaxResults}{The maximum number of results to return in a single call.}
}
\description{
Returns all the groups to which an entity belongs.

See \url{https://www.paws-r-sdk.com/docs/workmail_list_groups_for_entity/} for full documentation.
}
\keyword{internal}
