% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_batch_detect_key_phrases}
\alias{comprehend_batch_detect_key_phrases}
\title{Detects the key noun phrases found in a batch of documents}
\usage{
comprehend_batch_detect_key_phrases(TextList, LanguageCode)
}
\arguments{
\item{TextList}{[required] A list containing the text of the input documents. The list can contain
a maximum of 25 documents. Each document must contain fewer that 5,000
bytes of UTF-8 encoded characters.}

\item{LanguageCode}{[required] The language of the input documents. You can specify English ("en") or
Spanish ("es"). All documents must be in the same language.}
}
\description{
Detects the key noun phrases found in a batch of documents.
}
\section{Request syntax}{
\preformatted{svc$batch_detect_key_phrases(
  TextList = list(
    "string"
  ),
  LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"
)
}
}

\keyword{internal}
