# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Comprehend Medical
#'
#' @description
#' Comprehend Medical extracts structured information from unstructured
#' clinical text. Use these actions to gain insight in your documents.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- comprehendmedical(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- comprehendmedical()
#' svc$detect_entities(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=comprehendmedical_detect_entities]{detect_entities} \tab Inspects the clinical text for a variety of medical entities and returns specific information about them such as entity category, location, and confidence score on that information \cr
#'  \link[=comprehendmedical_detect_phi]{detect_phi} \tab Inspects the clinical text for personal health information (PHI) entities and entity category, location, and confidence score on that information 
#' }
#'
#' @rdname comprehendmedical
#' @export
comprehendmedical <- function(config = list()) {
  svc <- .comprehendmedical$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.comprehendmedical <- list()

.comprehendmedical$operations <- list()

.comprehendmedical$metadata <- list(
  service_name = "comprehendmedical",
  endpoints = list("*" = list(endpoint = "comprehendmedical.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "comprehendmedical.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "ComprehendMedical",
  api_version = "2018-10-30",
  signing_name = "comprehendmedical",
  json_version = "1.1",
  target_prefix = "ComprehendMedical_20181030"
)

.comprehendmedical$handlers <- new_handlers("jsonrpc", "v4")

.comprehendmedical$service <- function(config = list()) {
  new_service(.comprehendmedical$metadata, .comprehendmedical$handlers, config)
}
