% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_auto_ml_job}
\alias{sagemaker_create_auto_ml_job}
\title{Creates an AutoPilot job}
\usage{
sagemaker_create_auto_ml_job(AutoMLJobName, InputDataConfig,
  OutputDataConfig, ProblemType, AutoMLJobObjective, AutoMLJobConfig,
  RoleArn, GenerateCandidateDefinitionsOnly, Tags)
}
\arguments{
\item{AutoMLJobName}{[required] Identifies an AutoPilot job. Must be unique to your account and is
case-insensitive.}

\item{InputDataConfig}{[required] Similar to InputDataConfig supported by Tuning. Format(s) supported:
CSV. Minimum of 1000 rows.}

\item{OutputDataConfig}{[required] Similar to OutputDataConfig supported by Tuning. Format(s) supported:
CSV.}

\item{ProblemType}{Defines the kind of preprocessing and algorithms intended for the
candidates. Options include: BinaryClassification,
MulticlassClassification, and Regression.}

\item{AutoMLJobObjective}{Defines the job\'s objective. You provide a MetricName and AutoML will
infer minimize or maximize. If this is not provided, the most commonly
used ObjectiveMetric for problem type will be selected.}

\item{AutoMLJobConfig}{Contains CompletionCriteria and SecurityConfig.}

\item{RoleArn}{[required] The ARN of the role that will be used to access the data.}

\item{GenerateCandidateDefinitionsOnly}{This will generate possible candidates without training a model. A
candidate is a combination of data preprocessors, algorithms, and
algorithm parameter settings.}

\item{Tags}{Each tag consists of a key and an optional value. Tag keys must be
unique per resource.}
}
\description{
Creates an AutoPilot job.
}
\details{
After you run an AutoPilot job, you can find the best performing model
by calling , and then deploy that model by following the steps described
in \href{https://docs.aws.amazon.com/sagemaker/latest/dg/ex1-deploy-model.html}{Step 6.1: Deploy the Model to Amazon SageMaker Hosting Services}.

For information about how to use AutoPilot, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html}{Use AutoPilot to Automate Model Development}.
}
\section{Request syntax}{
\preformatted{svc$create_auto_ml_job(
  AutoMLJobName = "string",
  InputDataConfig = list(
    list(
      DataSource = list(
        S3DataSource = list(
          S3DataType = "ManifestFile"|"S3Prefix",
          S3Uri = "string"
        )
      ),
      CompressionType = "None"|"Gzip",
      TargetAttributeName = "string"
    )
  ),
  OutputDataConfig = list(
    KmsKeyId = "string",
    S3OutputPath = "string"
  ),
  ProblemType = "BinaryClassification"|"MulticlassClassification"|"Regression",
  AutoMLJobObjective = list(
    MetricName = "Accuracy"|"MSE"|"F1"|"F1macro"
  ),
  AutoMLJobConfig = list(
    CompletionCriteria = list(
      MaxCandidates = 123,
      MaxRuntimePerTrainingJobInSeconds = 123,
      MaxAutoMLJobRuntimeInSeconds = 123
    ),
    SecurityConfig = list(
      VolumeKmsKeyId = "string",
      EnableInterContainerTrafficEncryption = TRUE|FALSE,
      VpcConfig = list(
        SecurityGroupIds = list(
          "string"
        ),
        Subnets = list(
          "string"
        )
      )
    )
  ),
  RoleArn = "string",
  GenerateCandidateDefinitionsOnly = TRUE|FALSE,
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
