% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_trial_component}
\alias{sagemaker_create_trial_component}
\title{Creates a \emph{trial component}, which is a stage of a machine learning
\emph{trial}}
\usage{
sagemaker_create_trial_component(TrialComponentName, DisplayName,
  Status, StartTime, EndTime, Parameters, InputArtifacts, OutputArtifacts,
  Tags)
}
\arguments{
\item{TrialComponentName}{[required] The name of the component. The name must be unique in your AWS account
and is not case-sensitive.}

\item{DisplayName}{The name of the component as displayed. The name doesn\'t need to be
unique. If \code{DisplayName} isn\'t specified, \code{TrialComponentName} is
displayed.}

\item{Status}{The status of the component. States include:
\itemize{
\item InProgress
\item Completed
\item Failed
}}

\item{StartTime}{When the component started.}

\item{EndTime}{When the component ended.}

\item{Parameters}{The hyperparameters for the component.}

\item{InputArtifacts}{The input artifacts for the component. Examples of input artifacts are
datasets, algorithms, hyperparameters, source code, and instance types.}

\item{OutputArtifacts}{The output artifacts for the component. Examples of output artifacts are
metrics, snapshots, logs, and images.}

\item{Tags}{A list of tags to associate with the component. You can use Search API
to search on the tags.}
}
\description{
Creates a \emph{trial component}, which is a stage of a machine learning
\emph{trial}. A trial is composed of one or more trial components. A trial
component can be used in multiple trials.
}
\details{
Trial components include pre-processing jobs, training jobs, and batch
transform jobs.

When you use Amazon SageMaker Studio or the Amazon SageMaker Python SDK,
all experiments, trials, and trial components are automatically tracked,
logged, and indexed. When you use the AWS SDK for Python (Boto), you
must use the logging APIs provided by the SDK.

You can add tags to a trial component and then use the Search API to
search for the tags.

\code{CreateTrialComponent} can only be invoked from within an Amazon
SageMaker managed environment. This includes Amazon SageMaker training
jobs, processing jobs, transform jobs, and Amazon SageMaker notebooks. A
call to \code{CreateTrialComponent} from outside one of these environments
results in an error.
}
\section{Request syntax}{
\preformatted{svc$create_trial_component(
  TrialComponentName = "string",
  DisplayName = "string",
  Status = list(
    PrimaryStatus = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
    Message = "string"
  ),
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  Parameters = list(
    list(
      StringValue = "string",
      NumberValue = 123.0
    )
  ),
  InputArtifacts = list(
    list(
      MediaType = "string",
      Value = "string"
    )
  ),
  OutputArtifacts = list(
    list(
      MediaType = "string",
      Value = "string"
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
