# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include augmentedairuntime_service.R
NULL

#' Deletes the specified human loop for a flow definition
#'
#' @description
#' Deletes the specified human loop for a flow definition.
#'
#' See [https://paws-r.github.io/docs/augmentedairuntime/delete_human_loop.html](https://paws-r.github.io/docs/augmentedairuntime/delete_human_loop.html) for full documentation.
#'
#' @param HumanLoopName &#91;required&#93; The name of the human loop that you want to delete.
#'
#' @keywords internal
#'
#' @rdname augmentedairuntime_delete_human_loop
augmentedairuntime_delete_human_loop <- function(HumanLoopName) {
  op <- new_operation(
    name = "DeleteHumanLoop",
    http_method = "DELETE",
    http_path = "/human-loops/{HumanLoopName}",
    paginator = list()
  )
  input <- .augmentedairuntime$delete_human_loop_input(HumanLoopName = HumanLoopName)
  output <- .augmentedairuntime$delete_human_loop_output()
  config <- get_config()
  svc <- .augmentedairuntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.augmentedairuntime$operations$delete_human_loop <- augmentedairuntime_delete_human_loop

#' Returns information about the specified human loop
#'
#' @description
#' Returns information about the specified human loop. If the human loop was deleted, this operation will return a `ResourceNotFoundException` error.
#'
#' See [https://paws-r.github.io/docs/augmentedairuntime/describe_human_loop.html](https://paws-r.github.io/docs/augmentedairuntime/describe_human_loop.html) for full documentation.
#'
#' @param HumanLoopName &#91;required&#93; The name of the human loop that you want information about.
#'
#' @keywords internal
#'
#' @rdname augmentedairuntime_describe_human_loop
augmentedairuntime_describe_human_loop <- function(HumanLoopName) {
  op <- new_operation(
    name = "DescribeHumanLoop",
    http_method = "GET",
    http_path = "/human-loops/{HumanLoopName}",
    paginator = list()
  )
  input <- .augmentedairuntime$describe_human_loop_input(HumanLoopName = HumanLoopName)
  output <- .augmentedairuntime$describe_human_loop_output()
  config <- get_config()
  svc <- .augmentedairuntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.augmentedairuntime$operations$describe_human_loop <- augmentedairuntime_describe_human_loop

#' Returns information about human loops, given the specified parameters
#'
#' @description
#' Returns information about human loops, given the specified parameters. If a human loop was deleted, it will not be included.
#'
#' See [https://paws-r.github.io/docs/augmentedairuntime/list_human_loops.html](https://paws-r.github.io/docs/augmentedairuntime/list_human_loops.html) for full documentation.
#'
#' @param CreationTimeAfter (Optional) The timestamp of the date when you want the human loops to
#' begin in ISO 8601 format. For example, `2020-02-24`.
#' @param CreationTimeBefore (Optional) The timestamp of the date before which you want the human
#' loops to begin in ISO 8601 format. For example, `2020-02-24`.
#' @param FlowDefinitionArn &#91;required&#93; The Amazon Resource Name (ARN) of a flow definition.
#' @param SortOrder Optional. The order for displaying results. Valid values: `Ascending`
#' and `Descending`.
#' @param NextToken A token to display the next page of results.
#' @param MaxResults The total number of items to return. If the total number of available
#' items is more than the value specified in `MaxResults`, then a
#' `NextToken` is returned in the output. You can use this token to display
#' the next page of results.
#'
#' @keywords internal
#'
#' @rdname augmentedairuntime_list_human_loops
augmentedairuntime_list_human_loops <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, FlowDefinitionArn, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListHumanLoops",
    http_method = "GET",
    http_path = "/human-loops",
    paginator = list()
  )
  input <- .augmentedairuntime$list_human_loops_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, FlowDefinitionArn = FlowDefinitionArn, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .augmentedairuntime$list_human_loops_output()
  config <- get_config()
  svc <- .augmentedairuntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.augmentedairuntime$operations$list_human_loops <- augmentedairuntime_list_human_loops

#' Starts a human loop, provided that at least one activation condition is
#' met
#'
#' @description
#' Starts a human loop, provided that at least one activation condition is met.
#'
#' See [https://paws-r.github.io/docs/augmentedairuntime/start_human_loop.html](https://paws-r.github.io/docs/augmentedairuntime/start_human_loop.html) for full documentation.
#'
#' @param HumanLoopName &#91;required&#93; The name of the human loop.
#' @param FlowDefinitionArn &#91;required&#93; The Amazon Resource Name (ARN) of the flow definition associated with
#' this human loop.
#' @param HumanLoopInput &#91;required&#93; An object that contains information about the human loop.
#' @param DataAttributes Attributes of the specified data. Use `DataAttributes` to specify if
#' your data is free of personally identifiable information and/or free of
#' adult content.
#'
#' @keywords internal
#'
#' @rdname augmentedairuntime_start_human_loop
augmentedairuntime_start_human_loop <- function(HumanLoopName, FlowDefinitionArn, HumanLoopInput, DataAttributes = NULL) {
  op <- new_operation(
    name = "StartHumanLoop",
    http_method = "POST",
    http_path = "/human-loops",
    paginator = list()
  )
  input <- .augmentedairuntime$start_human_loop_input(HumanLoopName = HumanLoopName, FlowDefinitionArn = FlowDefinitionArn, HumanLoopInput = HumanLoopInput, DataAttributes = DataAttributes)
  output <- .augmentedairuntime$start_human_loop_output()
  config <- get_config()
  svc <- .augmentedairuntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.augmentedairuntime$operations$start_human_loop <- augmentedairuntime_start_human_loop

#' Stops the specified human loop
#'
#' @description
#' Stops the specified human loop.
#'
#' See [https://paws-r.github.io/docs/augmentedairuntime/stop_human_loop.html](https://paws-r.github.io/docs/augmentedairuntime/stop_human_loop.html) for full documentation.
#'
#' @param HumanLoopName &#91;required&#93; The name of the human loop that you want to stop.
#'
#' @keywords internal
#'
#' @rdname augmentedairuntime_stop_human_loop
augmentedairuntime_stop_human_loop <- function(HumanLoopName) {
  op <- new_operation(
    name = "StopHumanLoop",
    http_method = "POST",
    http_path = "/human-loops/stop",
    paginator = list()
  )
  input <- .augmentedairuntime$stop_human_loop_input(HumanLoopName = HumanLoopName)
  output <- .augmentedairuntime$stop_human_loop_output()
  config <- get_config()
  svc <- .augmentedairuntime$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.augmentedairuntime$operations$stop_human_loop <- augmentedairuntime_stop_human_loop
