% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_list_custom_models}
\alias{bedrock_list_custom_models}
\title{Returns a list of the custom models that you have created with the
CreateModelCustomizationJob operation}
\usage{
bedrock_list_custom_models(
  creationTimeBefore = NULL,
  creationTimeAfter = NULL,
  nameContains = NULL,
  baseModelArnEquals = NULL,
  foundationModelArnEquals = NULL,
  maxResults = NULL,
  nextToken = NULL,
  sortBy = NULL,
  sortOrder = NULL,
  isOwned = NULL
)
}
\arguments{
\item{creationTimeBefore}{Return custom models created before the specified time.}

\item{creationTimeAfter}{Return custom models created after the specified time.}

\item{nameContains}{Return custom models only if the job name contains these characters.}

\item{baseModelArnEquals}{Return custom models only if the base model Amazon Resource Name (ARN)
matches this parameter.}

\item{foundationModelArnEquals}{Return custom models only if the foundation model Amazon Resource Name
(ARN) matches this parameter.}

\item{maxResults}{The maximum number of results to return in the response. If the total
number of results is greater than this value, use the token returned in
the response in the \code{nextToken} field when making another request to
return the next batch of results.}

\item{nextToken}{If the total number of results is greater than the \code{maxResults} value
provided in the request, enter the token returned in the \code{nextToken}
field in the response in this field to return the next batch of results.}

\item{sortBy}{The field to sort by in the returned list of models.}

\item{sortOrder}{The sort order of the results.}

\item{isOwned}{Return custom models depending on if the current account owns them
(\code{true}) or if they were shared with the current account (\code{false}).}
}
\description{
Returns a list of the custom models that you have created with the \code{\link[=bedrock_create_model_customization_job]{create_model_customization_job}} operation.

See \url{https://www.paws-r-sdk.com/docs/bedrock_list_custom_models/} for full documentation.
}
\keyword{internal}
