% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_create_flywheel}
\alias{comprehend_create_flywheel}
\title{A flywheel is an Amazon Web Services resource that orchestrates the
ongoing training of a model for custom classification or custom entity
recognition}
\usage{
comprehend_create_flywheel(
  FlywheelName,
  ActiveModelArn = NULL,
  DataAccessRoleArn,
  TaskConfig = NULL,
  ModelType = NULL,
  DataLakeS3Uri,
  DataSecurityConfig = NULL,
  ClientRequestToken = NULL,
  Tags = NULL
)
}
\arguments{
\item{FlywheelName}{[required] Name for the flywheel.}

\item{ActiveModelArn}{To associate an existing model with the flywheel, specify the Amazon
Resource Number (ARN) of the model version. Do not set \code{TaskConfig} or
\code{ModelType} if you specify an \code{ActiveModelArn}.}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role that grants Amazon
Comprehend the permissions required to access the flywheel data in the
data lake.}

\item{TaskConfig}{Configuration about the model associated with the flywheel. You need to
set \code{TaskConfig} if you are creating a flywheel for a new model.}

\item{ModelType}{The model type. You need to set \code{ModelType} if you are creating a
flywheel for a new model.}

\item{DataLakeS3Uri}{[required] Enter the S3 location for the data lake. You can specify a new S3 bucket
or a new folder of an existing S3 bucket. The flywheel creates the data
lake at this location.}

\item{DataSecurityConfig}{Data security configurations.}

\item{ClientRequestToken}{A unique identifier for the request. If you don't set the client request
token, Amazon Comprehend generates one.}

\item{Tags}{The tags to associate with this flywheel.}
}
\description{
A flywheel is an Amazon Web Services resource that orchestrates the ongoing training of a model for custom classification or custom entity recognition. You can create a flywheel to start with an existing trained model, or Comprehend can create and train a new model.

See \url{https://www.paws-r-sdk.com/docs/comprehend_create_flywheel/} for full documentation.
}
\keyword{internal}
