% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_update_agent_action_group}
\alias{bedrockagent_update_agent_action_group}
\title{Updates the configuration for an action group for an agent}
\usage{
bedrockagent_update_agent_action_group(
  actionGroupExecutor = NULL,
  actionGroupId,
  actionGroupName,
  actionGroupState = NULL,
  agentId,
  agentVersion,
  apiSchema = NULL,
  description = NULL,
  functionSchema = NULL,
  parentActionGroupSignature = NULL
)
}
\arguments{
\item{actionGroupExecutor}{The Amazon Resource Name (ARN) of the Lambda function containing the
business logic that is carried out upon invoking the action.}

\item{actionGroupId}{[required] The unique identifier of the action group.}

\item{actionGroupName}{[required] Specifies a new name for the action group.}

\item{actionGroupState}{Specifies whether the action group is available for the agent to invoke
or not when sending an
\href{https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html}{InvokeAgent}
request.}

\item{agentId}{[required] The unique identifier of the agent for which to update the action group.}

\item{agentVersion}{[required] The unique identifier of the agent version for which to update the
action group.}

\item{apiSchema}{Contains either details about the S3 object containing the OpenAPI
schema for the action group or the JSON or YAML-formatted payload
defining the schema. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html}{Action group OpenAPI schemas}.}

\item{description}{Specifies a new name for the action group.}

\item{functionSchema}{Contains details about the function schema for the action group or the
JSON or YAML-formatted payload defining the schema.}

\item{parentActionGroupSignature}{To allow your agent to request the user for additional information when
trying to complete a task, set this field to \code{AMAZON.UserInput}. You
must leave the \code{description}, \code{apiSchema}, and \code{actionGroupExecutor}
fields blank for this action group.

During orchestration, if your agent determines that it needs to invoke
an API in an action group, but doesn't have enough information to
complete the API request, it will invoke this action group instead and
return an
\href{https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html}{Observation}
reprompting the user for more information.}
}
\description{
Updates the configuration for an action group for an agent.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_update_agent_action_group/} for full documentation.
}
\keyword{internal}
