% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_create_data_deletion_job}
\alias{personalize_create_data_deletion_job}
\title{Creates a batch job that deletes all references to specific users from
an Amazon Personalize dataset group in batches}
\usage{
personalize_create_data_deletion_job(
  jobName,
  datasetGroupArn,
  dataSource,
  roleArn,
  tags = NULL
)
}
\arguments{
\item{jobName}{[required] The name for the data deletion job.}

\item{datasetGroupArn}{[required] The Amazon Resource Name (ARN) of the dataset group that has the
datasets you want to delete records from.}

\item{dataSource}{[required] The Amazon S3 bucket that contains the list of userIds of the users to
delete.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of the IAM role that has permissions to
read from the Amazon S3 data source.}

\item{tags}{A list of
\href{https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html}{tags}
to apply to the data deletion job.}
}
\description{
Creates a batch job that deletes all references to specific users from an Amazon Personalize dataset group in batches. You specify the users to delete in a CSV file of userIds in an Amazon S3 bucket. After a job completes, Amazon Personalize no longer trains on the users’ data and no longer considers the users when generating user segments. For more information about creating a data deletion job, see \href{https://docs.aws.amazon.com/personalize/latest/dg/delete-records.html}{Deleting users}.

See \url{https://www.paws-r-sdk.com/docs/personalize_create_data_deletion_job/} for full documentation.
}
\keyword{internal}
