% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_list_cache_policies}
\alias{cloudfront_list_cache_policies}
\title{Gets a list of cache policies}
\usage{
cloudfront_list_cache_policies(Type, Marker, MaxItems)
}
\arguments{
\item{Type}{A filter to return only the specified kinds of cache policies. Valid
values are:
\itemize{
\item \code{managed} – Returns only the managed policies created by AWS.
\item \code{custom} – Returns only the custom policies created in your AWS
account.
}}

\item{Marker}{Use this field when paginating results to indicate where to begin in
your list of cache policies. The response includes cache policies in the
list that occur after the marker. To get the next page of the list, set
this field’s value to the value of \code{NextMarker} from the current page’s
response.}

\item{MaxItems}{The maximum number of cache policies that you want in the response.}
}
\description{
Gets a list of cache policies.

You can optionally apply a filter to return only the managed policies
created by AWS, or only the custom policies created in your AWS account.

You can optionally specify the maximum number of items to receive in the
response. If the total number of items in the list exceeds the maximum
that you specify, or the default maximum, the response is paginated. To
get the next page of items, send a subsequent request that specifies the
\code{NextMarker} value from the current response as the \code{Marker} value in
the subsequent request.
}
\section{Request syntax}{
\preformatted{svc$list_cache_policies(
  Type = "managed"|"custom",
  Marker = "string",
  MaxItems = "string"
)
}
}

\keyword{internal}
