% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_update_realtime_log_config}
\alias{cloudfront_update_realtime_log_config}
\title{Updates a real-time log configuration}
\usage{
cloudfront_update_realtime_log_config(EndPoints, Fields, Name, ARN,
  SamplingRate)
}
\arguments{
\item{EndPoints}{Contains information about the Amazon Kinesis data stream where you are
sending real-time log data.}

\item{Fields}{A list of fields to include in each real-time log record.

For more information about fields, see \href{https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-fields}{Real-time log configuration fields}
in the \emph{Amazon CloudFront Developer Guide}.}

\item{Name}{The name for this real-time log configuration.}

\item{ARN}{The Amazon Resource Name (ARN) for this real-time log configuration.}

\item{SamplingRate}{The sampling rate for this real-time log configuration. The sampling
rate determines the percentage of viewer requests that are represented
in the real-time log data. You must provide an integer between 1 and
100, inclusive.}
}
\description{
Updates a real-time log configuration.

When you update a real-time log configuration, all the parameters are
updated with the values provided in the request. You cannot update some
parameters independent of others. To update a real-time log
configuration:
\enumerate{
\item Call \code{GetRealtimeLogConfig} to get the current real-time log
configuration.
\item Locally modify the parameters in the real-time log configuration
that you want to update.
\item Call this API (\code{UpdateRealtimeLogConfig}) by providing the entire
real-time log configuration, including the parameters that you
modified and those that you didn’t.
}

You cannot update a real-time log configuration’s \code{Name} or \code{ARN}.
}
\section{Request syntax}{
\preformatted{svc$update_realtime_log_config(
  EndPoints = list(
    list(
      StreamType = "string",
      KinesisStreamConfig = list(
        RoleARN = "string",
        StreamARN = "string"
      )
    )
  ),
  Fields = list(
    "string"
  ),
  Name = "string",
  ARN = "string",
  SamplingRate = 123
)
}
}

\keyword{internal}
