% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_create_rule}
\alias{elbv2_create_rule}
\title{Creates a rule for the specified listener}
\usage{
elbv2_create_rule(ListenerArn, Conditions, Priority, Actions, Tags)
}
\arguments{
\item{ListenerArn}{[required] The Amazon Resource Name (ARN) of the listener.}

\item{Conditions}{[required] The conditions.}

\item{Priority}{[required] The rule priority. A listener can't have multiple rules with the same
priority.}

\item{Actions}{[required] The actions.}

\item{Tags}{The tags to assign to the rule.}
}
\description{
Creates a rule for the specified listener. The listener must be
associated with an Application Load Balancer.

Each rule consists of a priority, one or more actions, and one or more
conditions. Rules are evaluated in priority order, from the lowest value
to the highest value. When the conditions for a rule are met, its
actions are performed. If the conditions for no rules are met, the
actions for the default rule are performed. For more information, see
\href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules}{Listener rules}
in the \emph{Application Load Balancers Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_rule(
  ListenerArn = "string",
  Conditions = list(
    list(
      Field = "string",
      Values = list(
        "string"
      ),
      HostHeaderConfig = list(
        Values = list(
          "string"
        )
      ),
      PathPatternConfig = list(
        Values = list(
          "string"
        )
      ),
      HttpHeaderConfig = list(
        HttpHeaderName = "string",
        Values = list(
          "string"
        )
      ),
      QueryStringConfig = list(
        Values = list(
          list(
            Key = "string",
            Value = "string"
          )
        )
      ),
      HttpRequestMethodConfig = list(
        Values = list(
          "string"
        )
      ),
      SourceIpConfig = list(
        Values = list(
          "string"
        )
      )
    )
  ),
  Priority = 123,
  Actions = list(
    list(
      Type = "forward"|"authenticate-oidc"|"authenticate-cognito"|"redirect"|"fixed-response",
      TargetGroupArn = "string",
      AuthenticateOidcConfig = list(
        Issuer = "string",
        AuthorizationEndpoint = "string",
        TokenEndpoint = "string",
        UserInfoEndpoint = "string",
        ClientId = "string",
        ClientSecret = "string",
        SessionCookieName = "string",
        Scope = "string",
        SessionTimeout = 123,
        AuthenticationRequestExtraParams = list(
          "string"
        ),
        OnUnauthenticatedRequest = "deny"|"allow"|"authenticate",
        UseExistingClientSecret = TRUE|FALSE
      ),
      AuthenticateCognitoConfig = list(
        UserPoolArn = "string",
        UserPoolClientId = "string",
        UserPoolDomain = "string",
        SessionCookieName = "string",
        Scope = "string",
        SessionTimeout = 123,
        AuthenticationRequestExtraParams = list(
          "string"
        ),
        OnUnauthenticatedRequest = "deny"|"allow"|"authenticate"
      ),
      Order = 123,
      RedirectConfig = list(
        Protocol = "string",
        Port = "string",
        Host = "string",
        Path = "string",
        Query = "string",
        StatusCode = "HTTP_301"|"HTTP_302"
      ),
      FixedResponseConfig = list(
        MessageBody = "string",
        StatusCode = "string",
        ContentType = "string"
      ),
      ForwardConfig = list(
        TargetGroups = list(
          list(
            TargetGroupArn = "string",
            Weight = 123
          )
        ),
        TargetGroupStickinessConfig = list(
          Enabled = TRUE|FALSE,
          DurationSeconds = 123
        )
      )
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# This example creates a rule that forwards requests to the specified
# target group if the URL contains the specified pattern (for example,
# /img/*).
svc$create_rule(
  Actions = list(
    list(
      TargetGroupArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-t...",
      Type = "forward"
    )
  ),
  Conditions = list(
    list(
      Field = "path-pattern",
      Values = list(
        "/img/*"
      )
    )
  ),
  ListenerArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:listener/app/my-load-ba...",
  Priority = 10L
)
}

}
\keyword{internal}
