% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_delete_resolver_query_log_config}
\alias{route53resolver_delete_resolver_query_log_config}
\title{Deletes a query logging configuration}
\usage{
route53resolver_delete_resolver_query_log_config(
  ResolverQueryLogConfigId)
}
\arguments{
\item{ResolverQueryLogConfigId}{[required] The ID of the query logging configuration that you want to delete.}
}
\description{
Deletes a query logging configuration. When you delete a configuration,
Resolver stops logging DNS queries for all of the Amazon VPCs that are
associated with the configuration. This also applies if the query
logging configuration is shared with other AWS accounts, and the other
accounts have associated VPCs with the shared configuration.

Before you can delete a query logging configuration, you must first
disassociate all VPCs from the configuration. See
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html}{DisassociateResolverQueryLogConfig}.

If you used Resource Access Manager (RAM) to share a query logging
configuration with other accounts, you must stop sharing the
configuration before you can delete a configuration. The accounts that
you shared the configuration with can first disassociate VPCs that they
associated with the configuration, but that's not necessary. If you stop
sharing the configuration, those VPCs are automatically disassociated
from the configuration.
}
\section{Request syntax}{
\preformatted{svc$delete_resolver_query_log_config(
  ResolverQueryLogConfigId = "string"
)
}
}

\keyword{internal}
