% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_delete_resolver_rule}
\alias{route53resolver_delete_resolver_rule}
\title{Deletes a Resolver rule}
\usage{
route53resolver_delete_resolver_rule(ResolverRuleId)
}
\arguments{
\item{ResolverRuleId}{[required] The ID of the Resolver rule that you want to delete.}
}
\value{
A list with the following syntax:\preformatted{list(
  ResolverRule = list(
    Id = "string",
    CreatorRequestId = "string",
    Arn = "string",
    DomainName = "string",
    Status = "COMPLETE"|"DELETING"|"UPDATING"|"FAILED",
    StatusMessage = "string",
    RuleType = "FORWARD"|"SYSTEM"|"RECURSIVE",
    Name = "string",
    TargetIps = list(
      list(
        Ip = "string",
        Port = 123
      )
    ),
    ResolverEndpointId = "string",
    OwnerId = "string",
    ShareStatus = "NOT_SHARED"|"SHARED_WITH_ME"|"SHARED_BY_ME",
    CreationTime = "string",
    ModificationTime = "string"
  )
)
}
}
\description{
Deletes a Resolver rule. Before you can delete a Resolver rule, you must
disassociate it from all the VPCs that you associated the Resolver rule
with. For more information, see
\code{\link[=route53resolver_disassociate_resolver_rule]{disassociate_resolver_rule}}.
}
\section{Request syntax}{
\preformatted{svc$delete_resolver_rule(
  ResolverRuleId = "string"
)
}
}

\keyword{internal}
