% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_create_target_group}
\alias{elbv2_create_target_group}
\title{Creates a target group}
\usage{
elbv2_create_target_group(Name, Protocol, Port, VpcId,
  HealthCheckProtocol, HealthCheckPort, HealthCheckEnabled,
  HealthCheckPath, HealthCheckIntervalSeconds, HealthCheckTimeoutSeconds,
  HealthyThresholdCount, UnhealthyThresholdCount, Matcher, TargetType)
}
\arguments{
\item{Name}{[required] The name of the target group.

This name must be unique per region per account, can have a maximum of
32 characters, must contain only alphanumeric characters or hyphens, and
must not begin or end with a hyphen.}

\item{Protocol}{The protocol to use for routing traffic to the targets. For Application
Load Balancers, the supported protocols are HTTP and HTTPS. For Network
Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP\_UDP.
A TCP\_UDP listener must be associated with a TCP\_UDP target group. If
the target is a Lambda function, this parameter does not apply.}

\item{Port}{The port on which the targets receive traffic. This port is used unless
you specify a port override when registering the target. If the target
is a Lambda function, this parameter does not apply.}

\item{VpcId}{The identifier of the virtual private cloud (VPC). If the target is a
Lambda function, this parameter does not apply.}

\item{HealthCheckProtocol}{The protocol the load balancer uses when performing health checks on
targets. For Application Load Balancers, the default is HTTP. For
Network Load Balancers, the default is TCP. The TCP protocol is
supported for health checks only if the protocol of the target group is
TCP, TLS, UDP, or TCP\_UDP. The TLS, UDP, and TCP\_UDP protocols are not
supported for health checks.}

\item{HealthCheckPort}{The port the load balancer uses when performing health checks on
targets. The default is \code{traffic-port}, which is the port on which each
target receives traffic from the load balancer.}

\item{HealthCheckEnabled}{Indicates whether health checks are enabled. If the target type is
\code{lambda}, health checks are disabled by default but can be enabled. If
the target type is \code{instance} or \code{ip}, health checks are always enabled
and cannot be disabled.}

\item{HealthCheckPath}{[HTTP/HTTPS health checks] The ping path that is the destination on
the targets for health checks. The default is /.}

\item{HealthCheckIntervalSeconds}{The approximate amount of time, in seconds, between health checks of an
individual target. For HTTP and HTTPS health checks, the range is 5--300
seconds. For TCP health checks, the supported values are 10 and 30
seconds. If the target type is \code{instance} or \code{ip}, the default is 30
seconds. If the target type is \code{lambda}, the default is 35 seconds.}

\item{HealthCheckTimeoutSeconds}{The amount of time, in seconds, during which no response from a target
means a failed health check. For target groups with a protocol of HTTP
or HTTPS, the default is 5 seconds. For target groups with a protocol of
TCP or TLS, this value must be 6 seconds for HTTP health checks and 10
seconds for TCP and HTTPS health checks. If the target type is \code{lambda},
the default is 30 seconds.}

\item{HealthyThresholdCount}{The number of consecutive health checks successes required before
considering an unhealthy target healthy. For target groups with a
protocol of HTTP or HTTPS, the default is 5. For target groups with a
protocol of TCP or TLS, the default is 3. If the target type is
\code{lambda}, the default is 5.}

\item{UnhealthyThresholdCount}{The number of consecutive health check failures required before
considering a target unhealthy. For target groups with a protocol of
HTTP or HTTPS, the default is 2. For target groups with a protocol of
TCP or TLS, this value must be the same as the healthy threshold count.
If the target type is \code{lambda}, the default is 2.}

\item{Matcher}{[HTTP/HTTPS health checks] The HTTP codes to use when checking for a
successful response from a target.}

\item{TargetType}{The type of target that you must specify when registering targets with
this target group. You can't specify targets for a target group using
more than one target type.
\itemize{
\item \code{instance} - Targets are specified by instance ID. This is the
default value. If the target group protocol is UDP or TCP\_UDP, the
target type must be \code{instance}.
\item \code{ip} - Targets are specified by IP address. You can specify IP
addresses from the subnets of the virtual private cloud (VPC) for
the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't
specify publicly routable IP addresses.
\item \code{lambda} - The target groups contains a single Lambda function.
}}
}
\description{
Creates a target group.
}
\details{
To register targets with the target group, use RegisterTargets. To
update the health check settings for the target group, use
ModifyTargetGroup. To monitor the health of targets in the target group,
use DescribeTargetHealth.

To route traffic to the targets in a target group, specify the target
group in an action using CreateListener or CreateRule.

To delete a target group, use DeleteTargetGroup.

This operation is idempotent, which means that it completes at most one
time. If you attempt to create multiple target groups with the same
settings, each call succeeds.

For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html}{Target Groups for Your Application Load Balancers}
in the \emph{Application Load Balancers Guide} or \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html}{Target Groups for Your Network Load Balancers}
in the \emph{Network Load Balancers Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_target_group(
  Name = "string",
  Protocol = "HTTP"|"HTTPS"|"TCP"|"TLS"|"UDP"|"TCP_UDP",
  Port = 123,
  VpcId = "string",
  HealthCheckProtocol = "HTTP"|"HTTPS"|"TCP"|"TLS"|"UDP"|"TCP_UDP",
  HealthCheckPort = "string",
  HealthCheckEnabled = TRUE|FALSE,
  HealthCheckPath = "string",
  HealthCheckIntervalSeconds = 123,
  HealthCheckTimeoutSeconds = 123,
  HealthyThresholdCount = 123,
  UnhealthyThresholdCount = 123,
  Matcher = list(
    HttpCode = "string"
  ),
  TargetType = "instance"|"ip"|"lambda"
)
}
}

\examples{
# This example creates a target group that you can use to route traffic to
# targets using HTTP on port 80. This target group uses the default health
# check configuration.
\donttest{svc$create_target_group(
  Name = "my-targets",
  Port = 80L,
  Protocol = "HTTP",
  VpcId = "vpc-3ac0fb5f"
)}

}
\keyword{internal}
