% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_group_policy}
\alias{iam_delete_group_policy}
\title{Deletes the specified inline policy that is embedded in the specified
IAM group}
\usage{
iam_delete_group_policy(GroupName, PolicyName)
}
\arguments{
\item{GroupName}{[required] The name (friendly name, not ARN) identifying the group that the policy
is embedded in.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \_+=,.@-}

\item{PolicyName}{[required] The name identifying the policy document to delete.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \_+=,.@-}
}
\description{
Deletes the specified inline policy that is embedded in the specified
IAM group.
}
\details{
A group can also have managed policies attached to it. To detach a
managed policy from a group, use DetachGroupPolicy. For more information
about policies, refer to \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_group_policy(
  GroupName = "string",
  PolicyName = "string"
)
}
}

\examples{
# The following command deletes the policy named ExamplePolicy from the
# group named Admins:
\donttest{svc$delete_group_policy(
  GroupName = "Admins",
  PolicyName = "ExamplePolicy"
)}

}
\keyword{internal}
