% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_update_detector}
\alias{guardduty_update_detector}
\title{Updates the Amazon GuardDuty detector specified by the detectorId}
\usage{
guardduty_update_detector(DetectorId, Enable,
  FindingPublishingFrequency, DataSources)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector to update.}

\item{Enable}{Specifies whether the detector is enabled or not enabled.}

\item{FindingPublishingFrequency}{An enum value that specifies how frequently findings are exported, such
as to CloudWatch Events.}

\item{DataSources}{Describes which data sources will be updated.}
}
\description{
Updates the Amazon GuardDuty detector specified by the detectorId.
}
\section{Request syntax}{
\preformatted{svc$update_detector(
  DetectorId = "string",
  Enable = TRUE|FALSE,
  FindingPublishingFrequency = "FIFTEEN_MINUTES"|"ONE_HOUR"|"SIX_HOURS",
  DataSources = list(
    S3Logs = list(
      Enable = TRUE|FALSE
    )
  )
)
}
}

\keyword{internal}
