% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_login_profile}
\alias{iam_create_login_profile}
\title{Creates a password for the specified user, giving the user the ability
to access AWS services through the AWS Management Console}
\usage{
iam_create_login_profile(UserName, Password, PasswordResetRequired)
}
\arguments{
\item{UserName}{[required] The name of the IAM user to create a password for. The user must already
exist.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}

\item{Password}{[required] The new password for the user.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} that is used to
validate this parameter is a string of characters. That string can
include almost any printable ASCII character from the space (\code{U+0020})
through the end of the ASCII character range (\verb{U+00FF}). You can also
include the tab (\code{U+0009}), line feed (\verb{U+000A}), and carriage return
(\verb{U+000D}) characters. Any of these characters are valid in a password.
However, many tools, such as the AWS Management Console, might restrict
the ability to type certain characters because they have special meaning
within that tool.}

\item{PasswordResetRequired}{Specifies whether the user is required to set a new password on next
sign-in.}
}
\description{
Creates a password for the specified user, giving the user the ability
to access AWS services through the AWS Management Console. For more
information about managing passwords, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_admin-change-user.html}{Managing Passwords}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_login_profile(
  UserName = "string",
  Password = "string",
  PasswordResetRequired = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# The following command changes IAM user Bob's password and sets the flag
# that required Bob to change the password the next time he signs in.
svc$create_login_profile(
  Password = "h]6EszR\}vJ*m",
  PasswordResetRequired = TRUE,
  UserName = "Bob"
)
}

}
\keyword{internal}
