% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_open_id_connect_provider}
\alias{iam_get_open_id_connect_provider}
\title{Returns information about the specified OpenID Connect (OIDC) provider
resource object in IAM}
\usage{
iam_get_open_id_connect_provider(OpenIDConnectProviderArn)
}
\arguments{
\item{OpenIDConnectProviderArn}{[required] The Amazon Resource Name (ARN) of the OIDC provider resource object in
IAM to get information for. You can get a list of OIDC provider resource
ARNs by using the
\code{\link[=iam_list_open_id_connect_providers]{list_open_id_connect_providers}}
operation.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Url = "string",
  ClientIDList = list(
    "string"
  ),
  ThumbprintList = list(
    "string"
  ),
  CreateDate = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Returns information about the specified OpenID Connect (OIDC) provider
resource object in IAM.
}
\section{Request syntax}{
\preformatted{svc$get_open_id_connect_provider(
  OpenIDConnectProviderArn = "string"
)
}
}

\keyword{internal}
