% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_get_link_attributes}
\alias{clouddirectory_get_link_attributes}
\title{Retrieves attributes that are associated with a typed link}
\usage{
clouddirectory_get_link_attributes(DirectoryArn, TypedLinkSpecifier,
  AttributeNames, ConsistencyLevel)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) that is associated with the Directory
where the typed link resides. For more information, see arns or \href{https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink}{Typed Links}.}

\item{TypedLinkSpecifier}{[required] Allows a typed link specifier to be accepted as input.}

\item{AttributeNames}{[required] A list of attribute names whose values will be retrieved.}

\item{ConsistencyLevel}{The consistency level at which to retrieve the attributes on a typed
link.}
}
\value{
A list with the following syntax:\preformatted{list(
  Attributes = list(
    list(
      Key = list(
        SchemaArn = "string",
        FacetName = "string",
        Name = "string"
      ),
      Value = list(
        StringValue = "string",
        BinaryValue = raw,
        BooleanValue = TRUE|FALSE,
        NumberValue = "string",
        DatetimeValue = as.POSIXct(
          "2015-01-01"
        )
      )
    )
  )
)
}
}
\description{
Retrieves attributes that are associated with a typed link.
}
\section{Request syntax}{
\preformatted{svc$get_link_attributes(
  DirectoryArn = "string",
  TypedLinkSpecifier = list(
    TypedLinkFacet = list(
      SchemaArn = "string",
      TypedLinkName = "string"
    ),
    SourceObjectReference = list(
      Selector = "string"
    ),
    TargetObjectReference = list(
      Selector = "string"
    ),
    IdentityAttributeValues = list(
      list(
        AttributeName = "string",
        Value = list(
          StringValue = "string",
          BinaryValue = raw,
          BooleanValue = TRUE|FALSE,
          NumberValue = "string",
          DatetimeValue = as.POSIXct(
            "2015-01-01"
          )
        )
      )
    )
  ),
  AttributeNames = list(
    "string"
  ),
  ConsistencyLevel = "SERIALIZABLE"|"EVENTUAL"
)
}
}

\keyword{internal}
