% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_describe_publishing_destination}
\alias{guardduty_describe_publishing_destination}
\title{Returns information about the publishing destination specified by the
provided destinationId}
\usage{
guardduty_describe_publishing_destination(DetectorId, DestinationId)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector associated with the publishing destination
to retrieve.}

\item{DestinationId}{[required] The ID of the publishing destination to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  DestinationId = "string",
  DestinationType = "S3",
  Status = "PENDING_VERIFICATION"|"PUBLISHING"|"UNABLE_TO_PUBLISH_FIX_DESTINATION_PROPERTY"|"STOPPED",
  PublishingFailureStartTimestamp = 123,
  DestinationProperties = list(
    DestinationArn = "string",
    KmsKeyArn = "string"
  )
)
}
}
\description{
Returns information about the publishing destination specified by the
provided \code{destinationId}.
}
\section{Request syntax}{
\preformatted{svc$describe_publishing_destination(
  DetectorId = "string",
  DestinationId = "string"
)
}
}

\keyword{internal}
