% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_service_specific_credential}
\alias{iam_update_service_specific_credential}
\title{Sets the status of a service-specific credential to Active or Inactive}
\usage{
iam_update_service_specific_credential(UserName,
  ServiceSpecificCredentialId, Status)
}
\arguments{
\item{UserName}{The name of the IAM user associated with the service-specific
credential. If you do not specify this value, then the operation assumes
the user whose credentials are used to call the operation.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \_+=,.@-}

\item{ServiceSpecificCredentialId}{[required] The unique identifier of the service-specific credential.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters that
can consist of any upper or lowercased letter or digit.}

\item{Status}{[required] The status to be assigned to the service-specific credential.}
}
\description{
Sets the status of a service-specific credential to \code{Active} or
\code{Inactive}. Service-specific credentials that are inactive cannot be
used for authentication to the service. This operation can be used to
disable a user's service-specific credential as part of a credential
rotation work flow.
}
\section{Request syntax}{
\preformatted{svc$update_service_specific_credential(
  UserName = "string",
  ServiceSpecificCredentialId = "string",
  Status = "Active"|"Inactive"
)
}
}

\keyword{internal}
