% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_get_usage_statistics}
\alias{guardduty_get_usage_statistics}
\title{Lists Amazon GuardDuty usage statistics over the last 30 days for the
specified detector ID}
\usage{
guardduty_get_usage_statistics(
  DetectorId,
  UsageStatisticType,
  UsageCriteria,
  Unit = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DetectorId}{[required] The ID of the detector that specifies the GuardDuty service whose usage
statistics you want to retrieve.}

\item{UsageStatisticType}{[required] The type of usage statistics to retrieve.}

\item{UsageCriteria}{[required] Represents the criteria used for querying usage.}

\item{Unit}{The currency unit you would like to view your usage statistics in.
Current valid values are USD.}

\item{MaxResults}{The maximum number of results to return in the response.}

\item{NextToken}{A token to use for paginating results that are returned in the response.
Set the value of this parameter to null for the first request to a list
action. For subsequent calls, use the NextToken value returned from the
previous request to continue listing results after the first page.}
}
\description{
Lists Amazon GuardDuty usage statistics over the last 30 days for the specified detector ID. For newly enabled detectors or data sources, the cost returned will include only the usage so far under 30 days. This may differ from the cost metrics in the console, which project usage over 30 days to provide a monthly cost estimate. For more information, see \href{https://docs.aws.amazon.com/guardduty/latest/ug/monitoring_costs.html#usage-calculations}{Understanding How Usage Costs are Calculated}.

See \url{https://www.paws-r-sdk.com/docs/guardduty_get_usage_statistics/} for full documentation.
}
\keyword{internal}
