% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_simulate_custom_policy}
\alias{iam_simulate_custom_policy}
\title{Simulate how a set of IAM policies and optionally a resource-based
policy works with a list of API operations and Amazon Web Services
resources to determine the policies' effective permissions}
\usage{
iam_simulate_custom_policy(
  PolicyInputList,
  PermissionsBoundaryPolicyInputList = NULL,
  ActionNames,
  ResourceArns = NULL,
  ResourcePolicy = NULL,
  ResourceOwner = NULL,
  CallerArn = NULL,
  ContextEntries = NULL,
  ResourceHandlingOption = NULL,
  MaxItems = NULL,
  Marker = NULL
)
}
\arguments{
\item{PolicyInputList}{[required] A list of policy documents to include in the simulation. Each document
is specified as a string containing the complete, valid JSON text of an
IAM policy. Do not include any resource-based policies in this
parameter. Any resource-based policy must be submitted with the
\code{ResourcePolicy} parameter. The policies cannot be "scope-down"
policies, such as you could include in a call to
\href{https://docs.aws.amazon.com/IAM/latest/APIReference/}{GetFederationToken}
or one of the
\href{https://docs.aws.amazon.com/IAM/latest/APIReference/}{AssumeRole} API
operations. In other words, do not use policies designed to restrict
what a user can do while using the temporary credentials.

The maximum length of the policy document that you can pass in this
operation, including whitespace, is listed below. To view the maximum
character counts of a managed policy with no whitespaces, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length}{IAM and STS character quotas}.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\verb{U+000A}), and
carriage return (\verb{U+000D})
}}

\item{PermissionsBoundaryPolicyInputList}{The IAM permissions boundary policy to simulate. The permissions
boundary sets the maximum permissions that an IAM entity can have. You
can input only one permissions boundary when you pass a policy to this
operation. For more information about permissions boundaries, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html}{Permissions boundaries for IAM entities}
in the \emph{IAM User Guide}. The policy input is specified as a string that
contains the complete, valid JSON text of a permissions boundary policy.

The maximum length of the policy document that you can pass in this
operation, including whitespace, is listed below. To view the maximum
character counts of a managed policy with no whitespaces, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length}{IAM and STS character quotas}.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\verb{U+000A}), and
carriage return (\verb{U+000D})
}}

\item{ActionNames}{[required] A list of names of API operations to evaluate in the simulation. Each
operation is evaluated against each resource. Each operation must
include the service identifier, such as \code{iam:CreateUser}. This operation
does not support using wildcards (*) in an action name.}

\item{ResourceArns}{A list of ARNs of Amazon Web Services resources to include in the
simulation. If this parameter is not provided, then the value defaults
to \code{*} (all resources). Each API in the \code{ActionNames} parameter is
evaluated for each resource in this list. The simulation determines the
access result (allowed or denied) of each combination and reports it in
the response. You can simulate resources that don't exist in your
account.

The simulation does not automatically retrieve policies for the
specified resources. If you want to include a resource policy in the
simulation, then you must include the policy as a string in the
\code{ResourcePolicy} parameter.

If you include a \code{ResourcePolicy}, then it must be applicable to all of
the resources included in the simulation or you receive an invalid input
error.

For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference}.

Simulation of resource-based policies isn't supported for IAM roles.}

\item{ResourcePolicy}{A resource-based policy to include in the simulation provided as a
string. Each resource in the simulation is treated as if it had this
policy attached. You can include only one resource-based policy in a
simulation.

The maximum length of the policy document that you can pass in this
operation, including whitespace, is listed below. To view the maximum
character counts of a managed policy with no whitespaces, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length}{IAM and STS character quotas}.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\verb{U+000A}), and
carriage return (\verb{U+000D})
}

Simulation of resource-based policies isn't supported for IAM roles.}

\item{ResourceOwner}{An ARN representing the Amazon Web Services account ID that specifies
the owner of any simulated resource that does not identify its owner in
the resource ARN. Examples of resource ARNs include an S3 bucket or
object. If \code{ResourceOwner} is specified, it is also used as the account
owner of any \code{ResourcePolicy} included in the simulation. If the
\code{ResourceOwner} parameter is not specified, then the owner of the
resources and the resource policy defaults to the account of the
identity provided in \code{CallerArn}. This parameter is required only if you
specify a resource-based policy and account that owns the resource is
different from the account that owns the simulated calling user
\code{CallerArn}.

The ARN for an account uses the following syntax:
\code{arn:aws:iam::AWS-account-ID:root}. For example, to represent the
account with the 112233445566 ID, use the following ARN:
\verb{arn:aws:iam::112233445566-ID:root}.}

\item{CallerArn}{The ARN of the IAM user that you want to use as the simulated caller of
the API operations. \code{CallerArn} is required if you include a
\code{ResourcePolicy} so that the policy's \code{Principal} element has a value to
use in evaluating the policy.

You can specify only the ARN of an IAM user. You cannot specify the ARN
of an assumed role, federated user, or a service principal.}

\item{ContextEntries}{A list of context keys and corresponding values for the simulation to
use. Whenever a context key is evaluated in one of the simulated IAM
permissions policies, the corresponding value is supplied.}

\item{ResourceHandlingOption}{Specifies the type of simulation to run. Different API operations that
support resource-based policies require different combinations of
resources. By specifying the type of simulation to run, you enable the
policy simulator to enforce the presence of the required resources to
ensure reliable simulation results. If your simulation does not match
one of the following scenarios, then you can omit this parameter. The
following list shows each of the supported scenario values and the
resources that you must define to run the simulation.

Each of the EC2 scenarios requires that you specify instance, image, and
security group resources. If your scenario includes an EBS volume, then
you must specify that volume as a resource. If the EC2 scenario includes
VPC, then you must supply the network interface resource. If it includes
an IP subnet, then you must specify the subnet resource. For more
information on the EC2 scenario options, see \href{https://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/}{Supported platforms}
in the \emph{Amazon EC2 User Guide}.
\itemize{
\item \strong{EC2-VPC-InstanceStore}

instance, image, security group, network interface
\item \strong{EC2-VPC-InstanceStore-Subnet}

instance, image, security group, network interface, subnet
\item \strong{EC2-VPC-EBS}

instance, image, security group, network interface, volume
\item \strong{EC2-VPC-EBS-Subnet}

instance, image, security group, network interface, subnet, volume
}}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}
}
\description{
Simulate how a set of IAM policies and optionally a resource-based policy works with a list of API operations and Amazon Web Services resources to determine the policies' effective permissions. The policies are provided as strings.

See \url{https://www.paws-r-sdk.com/docs/iam_simulate_custom_policy/} for full documentation.
}
\keyword{internal}
