# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include verifiedpermissions_service.R
NULL

#' Makes a series of decisions about multiple authorization requests for
#' one principal or resource
#'
#' @description
#' Makes a series of decisions about multiple authorization requests for one principal or resource. Each request contains the equivalent content of an [`is_authorized`][verifiedpermissions_is_authorized] request: principal, action, resource, and context. Either the `principal` or the `resource` parameter must be identical across all requests. For example, Verified Permissions won't evaluate a pair of requests where `bob` views `photo1` and `alice` views `photo2`. Authorization of `bob` to view `photo1` and `photo2`, or `bob` and `alice` to view `photo1`, are valid batches.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_batch_is_authorized/](https://www.paws-r-sdk.com/docs/verifiedpermissions_batch_is_authorized/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store. Policies in this policy store will
#' be used to make the authorization decisions for the input.
#' @param entities Specifies the list of resources and principals and their associated
#' attributes that Verified Permissions can examine when evaluating the
#' policies.
#' 
#' You can include only principal and resource entities in this parameter;
#' you can't include actions. You must specify actions in the schema.
#' @param requests &#91;required&#93; An array of up to 30 requests that you want Verified Permissions to
#' evaluate.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_batch_is_authorized
verifiedpermissions_batch_is_authorized <- function(policyStoreId, entities = NULL, requests) {
  op <- new_operation(
    name = "BatchIsAuthorized",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$batch_is_authorized_input(policyStoreId = policyStoreId, entities = entities, requests = requests)
  output <- .verifiedpermissions$batch_is_authorized_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$batch_is_authorized <- verifiedpermissions_batch_is_authorized

#' Creates a reference to an Amazon Cognito user pool as an external
#' identity provider (IdP)
#'
#' @description
#' Creates a reference to an Amazon Cognito user pool as an external identity provider (IdP).
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_create_identity_source/](https://www.paws-r-sdk.com/docs/verifiedpermissions_create_identity_source/) for full documentation.
#'
#' @param clientToken Specifies a unique, case-sensitive ID that you provide to ensure the
#' idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store in which you want to store this
#' identity source. Only policies and requests made using this policy store
#' can reference identities from the identity provider configured in the
#' new identity source.
#' @param configuration &#91;required&#93; Specifies the details required to communicate with the identity provider
#' (IdP) associated with this identity source.
#' 
#' At this time, the only valid member of this structure is a Amazon
#' Cognito user pool configuration.
#' 
#' You must specify a `UserPoolArn`, and optionally, a `ClientId`.
#' @param principalEntityType Specifies the namespace and data type of the principals generated for
#' identities authenticated by the new identity source.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_create_identity_source
verifiedpermissions_create_identity_source <- function(clientToken = NULL, policyStoreId, configuration, principalEntityType = NULL) {
  op <- new_operation(
    name = "CreateIdentitySource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$create_identity_source_input(clientToken = clientToken, policyStoreId = policyStoreId, configuration = configuration, principalEntityType = principalEntityType)
  output <- .verifiedpermissions$create_identity_source_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$create_identity_source <- verifiedpermissions_create_identity_source

#' Creates a Cedar policy and saves it in the specified policy store
#'
#' @description
#' Creates a Cedar policy and saves it in the specified policy store. You can create either a static policy or a policy linked to a policy template.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_create_policy/](https://www.paws-r-sdk.com/docs/verifiedpermissions_create_policy/) for full documentation.
#'
#' @param clientToken Specifies a unique, case-sensitive ID that you provide to ensure the
#' idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#' @param policyStoreId &#91;required&#93; Specifies the `PolicyStoreId` of the policy store you want to store the
#' policy in.
#' @param definition &#91;required&#93; A structure that specifies the policy type and content to use for the
#' new policy. You must include either a static or a templateLinked
#' element. The policy content must be written in the Cedar policy
#' language.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_create_policy
verifiedpermissions_create_policy <- function(clientToken = NULL, policyStoreId, definition) {
  op <- new_operation(
    name = "CreatePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$create_policy_input(clientToken = clientToken, policyStoreId = policyStoreId, definition = definition)
  output <- .verifiedpermissions$create_policy_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$create_policy <- verifiedpermissions_create_policy

#' Creates a policy store
#'
#' @description
#' Creates a policy store. A policy store is a container for policy resources.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_create_policy_store/](https://www.paws-r-sdk.com/docs/verifiedpermissions_create_policy_store/) for full documentation.
#'
#' @param clientToken Specifies a unique, case-sensitive ID that you provide to ensure the
#' idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#' @param validationSettings &#91;required&#93; Specifies the validation setting for this policy store.
#' 
#' Currently, the only valid and required value is `Mode`.
#' 
#' We recommend that you turn on `STRICT` mode only after you define a
#' schema. If a schema doesn't exist, then `STRICT` mode causes any policy
#' to fail validation, and Verified Permissions rejects the policy. You can
#' turn off validation by using the
#' [`update_policy_store`][verifiedpermissions_update_policy_store]. Then,
#' when you have a schema defined, use
#' [`update_policy_store`][verifiedpermissions_update_policy_store] again
#' to turn validation back on.
#' @param description Descriptive text that you can provide to help with identification of the
#' current policy store.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_create_policy_store
verifiedpermissions_create_policy_store <- function(clientToken = NULL, validationSettings, description = NULL) {
  op <- new_operation(
    name = "CreatePolicyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$create_policy_store_input(clientToken = clientToken, validationSettings = validationSettings, description = description)
  output <- .verifiedpermissions$create_policy_store_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$create_policy_store <- verifiedpermissions_create_policy_store

#' Creates a policy template
#'
#' @description
#' Creates a policy template. A template can use placeholders for the principal and resource. A template must be instantiated into a policy by associating it with specific principals and resources to use for the placeholders. That instantiated policy can then be considered in authorization decisions. The instantiated policy works identically to any other policy, except that it is dynamically linked to the template. If the template changes, then any policies that are linked to that template are immediately updated as well.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_create_policy_template/](https://www.paws-r-sdk.com/docs/verifiedpermissions_create_policy_template/) for full documentation.
#'
#' @param clientToken Specifies a unique, case-sensitive ID that you provide to ensure the
#' idempotency of the request. This lets you safely retry the request
#' without accidentally performing the same operation a second time.
#' Passing the same value to a later call to an operation requires that you
#' also pass the same value for all other parameters. We recommend that you
#' use a [UUID type of
#' value.](https://en.wikipedia.org/wiki/Universally_unique_identifier).
#' 
#' If you don't provide this value, then Amazon Web Services generates a
#' random one for you.
#' 
#' If you retry the operation with the same `ClientToken`, but with
#' different parameters, the retry fails with an
#' `IdempotentParameterMismatch` error.
#' @param policyStoreId &#91;required&#93; The ID of the policy store in which to create the policy template.
#' @param description Specifies a description for the policy template.
#' @param statement &#91;required&#93; Specifies the content that you want to use for the new policy template,
#' written in the Cedar policy language.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_create_policy_template
verifiedpermissions_create_policy_template <- function(clientToken = NULL, policyStoreId, description = NULL, statement) {
  op <- new_operation(
    name = "CreatePolicyTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$create_policy_template_input(clientToken = clientToken, policyStoreId = policyStoreId, description = description, statement = statement)
  output <- .verifiedpermissions$create_policy_template_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$create_policy_template <- verifiedpermissions_create_policy_template

#' Deletes an identity source that references an identity provider (IdP)
#' such as Amazon Cognito
#'
#' @description
#' Deletes an identity source that references an identity provider (IdP) such as Amazon Cognito. After you delete the identity source, you can no longer use tokens for identities from that identity source to represent principals in authorization queries made using [`is_authorized_with_token`][verifiedpermissions_is_authorized_with_token]. operations.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_delete_identity_source/](https://www.paws-r-sdk.com/docs/verifiedpermissions_delete_identity_source/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that contains the identity source
#' that you want to delete.
#' @param identitySourceId &#91;required&#93; Specifies the ID of the identity source that you want to delete.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_delete_identity_source
verifiedpermissions_delete_identity_source <- function(policyStoreId, identitySourceId) {
  op <- new_operation(
    name = "DeleteIdentitySource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$delete_identity_source_input(policyStoreId = policyStoreId, identitySourceId = identitySourceId)
  output <- .verifiedpermissions$delete_identity_source_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$delete_identity_source <- verifiedpermissions_delete_identity_source

#' Deletes the specified policy from the policy store
#'
#' @description
#' Deletes the specified policy from the policy store.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_delete_policy/](https://www.paws-r-sdk.com/docs/verifiedpermissions_delete_policy/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that contains the policy that you
#' want to delete.
#' @param policyId &#91;required&#93; Specifies the ID of the policy that you want to delete.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_delete_policy
verifiedpermissions_delete_policy <- function(policyStoreId, policyId) {
  op <- new_operation(
    name = "DeletePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$delete_policy_input(policyStoreId = policyStoreId, policyId = policyId)
  output <- .verifiedpermissions$delete_policy_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$delete_policy <- verifiedpermissions_delete_policy

#' Deletes the specified policy store
#'
#' @description
#' Deletes the specified policy store.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_delete_policy_store/](https://www.paws-r-sdk.com/docs/verifiedpermissions_delete_policy_store/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that you want to delete.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_delete_policy_store
verifiedpermissions_delete_policy_store <- function(policyStoreId) {
  op <- new_operation(
    name = "DeletePolicyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$delete_policy_store_input(policyStoreId = policyStoreId)
  output <- .verifiedpermissions$delete_policy_store_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$delete_policy_store <- verifiedpermissions_delete_policy_store

#' Deletes the specified policy template from the policy store
#'
#' @description
#' Deletes the specified policy template from the policy store.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_delete_policy_template/](https://www.paws-r-sdk.com/docs/verifiedpermissions_delete_policy_template/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that contains the policy template
#' that you want to delete.
#' @param policyTemplateId &#91;required&#93; Specifies the ID of the policy template that you want to delete.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_delete_policy_template
verifiedpermissions_delete_policy_template <- function(policyStoreId, policyTemplateId) {
  op <- new_operation(
    name = "DeletePolicyTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$delete_policy_template_input(policyStoreId = policyStoreId, policyTemplateId = policyTemplateId)
  output <- .verifiedpermissions$delete_policy_template_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$delete_policy_template <- verifiedpermissions_delete_policy_template

#' Retrieves the details about the specified identity source
#'
#' @description
#' Retrieves the details about the specified identity source.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_get_identity_source/](https://www.paws-r-sdk.com/docs/verifiedpermissions_get_identity_source/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that contains the identity source
#' you want information about.
#' @param identitySourceId &#91;required&#93; Specifies the ID of the identity source you want information about.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_get_identity_source
verifiedpermissions_get_identity_source <- function(policyStoreId, identitySourceId) {
  op <- new_operation(
    name = "GetIdentitySource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$get_identity_source_input(policyStoreId = policyStoreId, identitySourceId = identitySourceId)
  output <- .verifiedpermissions$get_identity_source_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$get_identity_source <- verifiedpermissions_get_identity_source

#' Retrieves information about the specified policy
#'
#' @description
#' Retrieves information about the specified policy.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_get_policy/](https://www.paws-r-sdk.com/docs/verifiedpermissions_get_policy/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that contains the policy that you
#' want information about.
#' @param policyId &#91;required&#93; Specifies the ID of the policy you want information about.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_get_policy
verifiedpermissions_get_policy <- function(policyStoreId, policyId) {
  op <- new_operation(
    name = "GetPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$get_policy_input(policyStoreId = policyStoreId, policyId = policyId)
  output <- .verifiedpermissions$get_policy_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$get_policy <- verifiedpermissions_get_policy

#' Retrieves details about a policy store
#'
#' @description
#' Retrieves details about a policy store.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_get_policy_store/](https://www.paws-r-sdk.com/docs/verifiedpermissions_get_policy_store/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that you want information about.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_get_policy_store
verifiedpermissions_get_policy_store <- function(policyStoreId) {
  op <- new_operation(
    name = "GetPolicyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$get_policy_store_input(policyStoreId = policyStoreId)
  output <- .verifiedpermissions$get_policy_store_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$get_policy_store <- verifiedpermissions_get_policy_store

#' Retrieve the details for the specified policy template in the specified
#' policy store
#'
#' @description
#' Retrieve the details for the specified policy template in the specified policy store.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_get_policy_template/](https://www.paws-r-sdk.com/docs/verifiedpermissions_get_policy_template/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that contains the policy template
#' that you want information about.
#' @param policyTemplateId &#91;required&#93; Specifies the ID of the policy template that you want information about.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_get_policy_template
verifiedpermissions_get_policy_template <- function(policyStoreId, policyTemplateId) {
  op <- new_operation(
    name = "GetPolicyTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$get_policy_template_input(policyStoreId = policyStoreId, policyTemplateId = policyTemplateId)
  output <- .verifiedpermissions$get_policy_template_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$get_policy_template <- verifiedpermissions_get_policy_template

#' Retrieve the details for the specified schema in the specified policy
#' store
#'
#' @description
#' Retrieve the details for the specified schema in the specified policy store.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_get_schema/](https://www.paws-r-sdk.com/docs/verifiedpermissions_get_schema/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that contains the schema.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_get_schema
verifiedpermissions_get_schema <- function(policyStoreId) {
  op <- new_operation(
    name = "GetSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$get_schema_input(policyStoreId = policyStoreId)
  output <- .verifiedpermissions$get_schema_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$get_schema <- verifiedpermissions_get_schema

#' Makes an authorization decision about a service request described in the
#' parameters
#'
#' @description
#' Makes an authorization decision about a service request described in the parameters. The information in the parameters can also define additional context that Verified Permissions can include in the evaluation. The request is evaluated against all matching policies in the specified policy store. The result of the decision is either `Allow` or `Deny`, along with a list of the policies that resulted in the decision.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_is_authorized/](https://www.paws-r-sdk.com/docs/verifiedpermissions_is_authorized/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store. Policies in this policy store will
#' be used to make an authorization decision for the input.
#' @param principal Specifies the principal for which the authorization decision is to be
#' made.
#' @param action Specifies the requested action to be authorized. For example, is the
#' principal authorized to perform this action on the resource?
#' @param resource Specifies the resource for which the authorization decision is to be
#' made.
#' @param context Specifies additional context that can be used to make more granular
#' authorization decisions.
#' @param entities Specifies the list of resources and principals and their associated
#' attributes that Verified Permissions can examine when evaluating the
#' policies.
#' 
#' You can include only principal and resource entities in this parameter;
#' you can't include actions. You must specify actions in the schema.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_is_authorized
verifiedpermissions_is_authorized <- function(policyStoreId, principal = NULL, action = NULL, resource = NULL, context = NULL, entities = NULL) {
  op <- new_operation(
    name = "IsAuthorized",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$is_authorized_input(policyStoreId = policyStoreId, principal = principal, action = action, resource = resource, context = context, entities = entities)
  output <- .verifiedpermissions$is_authorized_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$is_authorized <- verifiedpermissions_is_authorized

#' Makes an authorization decision about a service request described in the
#' parameters
#'
#' @description
#' Makes an authorization decision about a service request described in the parameters. The principal in this request comes from an external identity source in the form of an identity token formatted as a [JSON web token (JWT)](https://en.wikipedia.org/wiki/JSON_Web_Token). The information in the parameters can also define additional context that Verified Permissions can include in the evaluation. The request is evaluated against all matching policies in the specified policy store. The result of the decision is either `Allow` or `Deny`, along with a list of the policies that resulted in the decision.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_is_authorized_with_token/](https://www.paws-r-sdk.com/docs/verifiedpermissions_is_authorized_with_token/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store. Policies in this policy store will
#' be used to make an authorization decision for the input.
#' @param identityToken Specifies an identity token for the principal to be authorized. This
#' token is provided to you by the identity provider (IdP) associated with
#' the specified identity source. You must specify either an `AccessToken`
#' or an `IdentityToken`, or both.
#' @param accessToken Specifies an access token for the principal to be authorized. This token
#' is provided to you by the identity provider (IdP) associated with the
#' specified identity source. You must specify either an `AccessToken`, or
#' an `IdentityToken`, or both.
#' @param action Specifies the requested action to be authorized. Is the specified
#' principal authorized to perform this action on the specified resource.
#' @param resource Specifies the resource for which the authorization decision is made. For
#' example, is the principal allowed to perform the action on the resource?
#' @param context Specifies additional context that can be used to make more granular
#' authorization decisions.
#' @param entities Specifies the list of resources and their associated attributes that
#' Verified Permissions can examine when evaluating the policies.
#' 
#' You can include only resource and action entities in this parameter; you
#' can't include principals.
#' 
#' -   The
#'     [`is_authorized_with_token`][verifiedpermissions_is_authorized_with_token]
#'     operation takes principal attributes from ***only*** the
#'     `identityToken` or `accessToken` passed to the operation.
#' 
#' -   For action entities, you can include only their `Identifier` and
#'     `EntityType`.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_is_authorized_with_token
verifiedpermissions_is_authorized_with_token <- function(policyStoreId, identityToken = NULL, accessToken = NULL, action = NULL, resource = NULL, context = NULL, entities = NULL) {
  op <- new_operation(
    name = "IsAuthorizedWithToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$is_authorized_with_token_input(policyStoreId = policyStoreId, identityToken = identityToken, accessToken = accessToken, action = action, resource = resource, context = context, entities = entities)
  output <- .verifiedpermissions$is_authorized_with_token_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$is_authorized_with_token <- verifiedpermissions_is_authorized_with_token

#' Returns a paginated list of all of the identity sources defined in the
#' specified policy store
#'
#' @description
#' Returns a paginated list of all of the identity sources defined in the specified policy store.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_list_identity_sources/](https://www.paws-r-sdk.com/docs/verifiedpermissions_list_identity_sources/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that contains the identity sources
#' that you want to list.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included in each
#' response. If additional items exist beyond the number you specify, the
#' `NextToken` response element is returned with a value (not null).
#' Include the specified value as the `NextToken` request parameter in the
#' next call to the operation to get the next set of results. Note that the
#' service might return fewer results than the maximum even when there are
#' more results available. You should check `NextToken` after every
#' operation to ensure that you receive all of the results.
#' 
#' If you do not specify this parameter, the operation defaults to 10
#' identity sources per response. You can specify a maximum of 200 identity
#' sources per response.
#' @param filters Specifies characteristics of an identity source that you can use to
#' limit the output to matching identity sources.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_list_identity_sources
verifiedpermissions_list_identity_sources <- function(policyStoreId, nextToken = NULL, maxResults = NULL, filters = NULL) {
  op <- new_operation(
    name = "ListIdentitySources",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "identitySources")
  )
  input <- .verifiedpermissions$list_identity_sources_input(policyStoreId = policyStoreId, nextToken = nextToken, maxResults = maxResults, filters = filters)
  output <- .verifiedpermissions$list_identity_sources_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$list_identity_sources <- verifiedpermissions_list_identity_sources

#' Returns a paginated list of all policies stored in the specified policy
#' store
#'
#' @description
#' Returns a paginated list of all policies stored in the specified policy store.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_list_policies/](https://www.paws-r-sdk.com/docs/verifiedpermissions_list_policies/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store you want to list policies from.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included in each
#' response. If additional items exist beyond the number you specify, the
#' `NextToken` response element is returned with a value (not null).
#' Include the specified value as the `NextToken` request parameter in the
#' next call to the operation to get the next set of results. Note that the
#' service might return fewer results than the maximum even when there are
#' more results available. You should check `NextToken` after every
#' operation to ensure that you receive all of the results.
#' 
#' If you do not specify this parameter, the operation defaults to 10
#' policies per response. You can specify a maximum of 50 policies per
#' response.
#' @param filter Specifies a filter that limits the response to only policies that match
#' the specified criteria. For example, you list only the policies that
#' reference a specified principal.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_list_policies
verifiedpermissions_list_policies <- function(policyStoreId, nextToken = NULL, maxResults = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "policies")
  )
  input <- .verifiedpermissions$list_policies_input(policyStoreId = policyStoreId, nextToken = nextToken, maxResults = maxResults, filter = filter)
  output <- .verifiedpermissions$list_policies_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$list_policies <- verifiedpermissions_list_policies

#' Returns a paginated list of all policy stores in the calling Amazon Web
#' Services account
#'
#' @description
#' Returns a paginated list of all policy stores in the calling Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_list_policy_stores/](https://www.paws-r-sdk.com/docs/verifiedpermissions_list_policy_stores/) for full documentation.
#'
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included in each
#' response. If additional items exist beyond the number you specify, the
#' `NextToken` response element is returned with a value (not null).
#' Include the specified value as the `NextToken` request parameter in the
#' next call to the operation to get the next set of results. Note that the
#' service might return fewer results than the maximum even when there are
#' more results available. You should check `NextToken` after every
#' operation to ensure that you receive all of the results.
#' 
#' If you do not specify this parameter, the operation defaults to 10
#' policy stores per response. You can specify a maximum of 50 policy
#' stores per response.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_list_policy_stores
verifiedpermissions_list_policy_stores <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListPolicyStores",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "policyStores")
  )
  input <- .verifiedpermissions$list_policy_stores_input(nextToken = nextToken, maxResults = maxResults)
  output <- .verifiedpermissions$list_policy_stores_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$list_policy_stores <- verifiedpermissions_list_policy_stores

#' Returns a paginated list of all policy templates in the specified policy
#' store
#'
#' @description
#' Returns a paginated list of all policy templates in the specified policy store.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_list_policy_templates/](https://www.paws-r-sdk.com/docs/verifiedpermissions_list_policy_templates/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that contains the policy templates
#' you want to list.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param maxResults Specifies the total number of results that you want included in each
#' response. If additional items exist beyond the number you specify, the
#' `NextToken` response element is returned with a value (not null).
#' Include the specified value as the `NextToken` request parameter in the
#' next call to the operation to get the next set of results. Note that the
#' service might return fewer results than the maximum even when there are
#' more results available. You should check `NextToken` after every
#' operation to ensure that you receive all of the results.
#' 
#' If you do not specify this parameter, the operation defaults to 10
#' policy templates per response. You can specify a maximum of 50 policy
#' templates per response.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_list_policy_templates
verifiedpermissions_list_policy_templates <- function(policyStoreId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListPolicyTemplates",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "policyTemplates")
  )
  input <- .verifiedpermissions$list_policy_templates_input(policyStoreId = policyStoreId, nextToken = nextToken, maxResults = maxResults)
  output <- .verifiedpermissions$list_policy_templates_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$list_policy_templates <- verifiedpermissions_list_policy_templates

#' Creates or updates the policy schema in the specified policy store
#'
#' @description
#' Creates or updates the policy schema in the specified policy store. The schema is used to validate any Cedar policies and policy templates submitted to the policy store. Any changes to the schema validate only policies and templates submitted after the schema change. Existing policies and templates are not re-evaluated against the changed schema. If you later update a policy, then it is evaluated against the new schema at that time.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_put_schema/](https://www.paws-r-sdk.com/docs/verifiedpermissions_put_schema/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store in which to place the schema.
#' @param definition &#91;required&#93; Specifies the definition of the schema to be stored. The schema
#' definition must be written in Cedar schema JSON.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_put_schema
verifiedpermissions_put_schema <- function(policyStoreId, definition) {
  op <- new_operation(
    name = "PutSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$put_schema_input(policyStoreId = policyStoreId, definition = definition)
  output <- .verifiedpermissions$put_schema_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$put_schema <- verifiedpermissions_put_schema

#' Updates the specified identity source to use a new identity provider
#' (IdP) source, or to change the mapping of identities from the IdP to a
#' different principal entity type
#'
#' @description
#' Updates the specified identity source to use a new identity provider (IdP) source, or to change the mapping of identities from the IdP to a different principal entity type.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_update_identity_source/](https://www.paws-r-sdk.com/docs/verifiedpermissions_update_identity_source/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that contains the identity source
#' that you want to update.
#' @param identitySourceId &#91;required&#93; Specifies the ID of the identity source that you want to update.
#' @param updateConfiguration &#91;required&#93; Specifies the details required to communicate with the identity provider
#' (IdP) associated with this identity source.
#' 
#' At this time, the only valid member of this structure is a Amazon
#' Cognito user pool configuration.
#' 
#' You must specify a `userPoolArn`, and optionally, a `ClientId`.
#' @param principalEntityType Specifies the data type of principals generated for identities
#' authenticated by the identity source.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_update_identity_source
verifiedpermissions_update_identity_source <- function(policyStoreId, identitySourceId, updateConfiguration, principalEntityType = NULL) {
  op <- new_operation(
    name = "UpdateIdentitySource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$update_identity_source_input(policyStoreId = policyStoreId, identitySourceId = identitySourceId, updateConfiguration = updateConfiguration, principalEntityType = principalEntityType)
  output <- .verifiedpermissions$update_identity_source_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$update_identity_source <- verifiedpermissions_update_identity_source

#' Modifies a Cedar static policy in the specified policy store
#'
#' @description
#' Modifies a Cedar static policy in the specified policy store. You can change only certain elements of the [UpdatePolicyDefinition](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/#amazonverifiedpermissions-UpdatePolicy-request-UpdatePolicyDefinition) parameter. You can directly update only static policies. To change a template-linked policy, you must update the template instead, using [`update_policy_template`][verifiedpermissions_update_policy_template].
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_update_policy/](https://www.paws-r-sdk.com/docs/verifiedpermissions_update_policy/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that contains the policy that you
#' want to update.
#' @param policyId &#91;required&#93; Specifies the ID of the policy that you want to update. To find this
#' value, you can use [`list_policies`][verifiedpermissions_list_policies].
#' @param definition &#91;required&#93; Specifies the updated policy content that you want to replace on the
#' specified policy. The content must be valid Cedar policy language text.
#' 
#' You can change only the following elements from the policy definition:
#' 
#' -   The `action` referenced by the policy.
#' 
#' -   Any conditional clauses, such as `when` or `unless` clauses.
#' 
#' You **can't** change the following elements:
#' 
#' -   Changing from `static` to `templateLinked`.
#' 
#' -   Changing the effect of the policy from `permit` or `forbid`.
#' 
#' -   The `principal` referenced by the policy.
#' 
#' -   The `resource` referenced by the policy.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_update_policy
verifiedpermissions_update_policy <- function(policyStoreId, policyId, definition) {
  op <- new_operation(
    name = "UpdatePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$update_policy_input(policyStoreId = policyStoreId, policyId = policyId, definition = definition)
  output <- .verifiedpermissions$update_policy_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$update_policy <- verifiedpermissions_update_policy

#' Modifies the validation setting for a policy store
#'
#' @description
#' Modifies the validation setting for a policy store.
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_update_policy_store/](https://www.paws-r-sdk.com/docs/verifiedpermissions_update_policy_store/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that you want to update
#' @param validationSettings &#91;required&#93; A structure that defines the validation settings that want to enable for
#' the policy store.
#' @param description Descriptive text that you can provide to help with identification of the
#' current policy store.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_update_policy_store
verifiedpermissions_update_policy_store <- function(policyStoreId, validationSettings, description = NULL) {
  op <- new_operation(
    name = "UpdatePolicyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$update_policy_store_input(policyStoreId = policyStoreId, validationSettings = validationSettings, description = description)
  output <- .verifiedpermissions$update_policy_store_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$update_policy_store <- verifiedpermissions_update_policy_store

#' Updates the specified policy template
#'
#' @description
#' Updates the specified policy template. You can update only the description and the some elements of the [policyBody](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyTemplate.html#amazonverifiedpermissions-UpdatePolicyTemplate-request-policyBody).
#'
#' See [https://www.paws-r-sdk.com/docs/verifiedpermissions_update_policy_template/](https://www.paws-r-sdk.com/docs/verifiedpermissions_update_policy_template/) for full documentation.
#'
#' @param policyStoreId &#91;required&#93; Specifies the ID of the policy store that contains the policy template
#' that you want to update.
#' @param policyTemplateId &#91;required&#93; Specifies the ID of the policy template that you want to update.
#' @param description Specifies a new description to apply to the policy template.
#' @param statement &#91;required&#93; Specifies new statement content written in Cedar policy language to
#' replace the current body of the policy template.
#' 
#' You can change only the following elements of the policy body:
#' 
#' -   The `action` referenced by the policy template.
#' 
#' -   Any conditional clauses, such as `when` or `unless` clauses.
#' 
#' You **can't** change the following elements:
#' 
#' -   The effect (`permit` or `forbid`) of the policy template.
#' 
#' -   The `principal` referenced by the policy template.
#' 
#' -   The `resource` referenced by the policy template.
#'
#' @keywords internal
#'
#' @rdname verifiedpermissions_update_policy_template
verifiedpermissions_update_policy_template <- function(policyStoreId, policyTemplateId, description = NULL, statement) {
  op <- new_operation(
    name = "UpdatePolicyTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .verifiedpermissions$update_policy_template_input(policyStoreId = policyStoreId, policyTemplateId = policyTemplateId, description = description, statement = statement)
  output <- .verifiedpermissions$update_policy_template_output()
  config <- get_config()
  svc <- .verifiedpermissions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.verifiedpermissions$operations$update_policy_template <- verifiedpermissions_update_policy_template
