% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_set_user_password}
\alias{cognitoidentityprovider_admin_set_user_password}
\title{Sets the specified user's password in a user pool as an administrator}
\usage{
cognitoidentityprovider_admin_set_user_password(
  UserPoolId,
  Username,
  Password,
  Permanent = NULL
)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool where you want to set the user's
password.}

\item{Username}{[required] The username of the user that you want to query or modify. The value of
this parameter is typically your user's username, but it can be any of
their alias attributes. If \code{username} isn't an alias attribute in your
user pool, this value must be the \code{sub} of a local user or the username
of a user from a third-party IdP.}

\item{Password}{[required] The password for the user.}

\item{Permanent}{\code{True} if the password is permanent, \code{False} if it is temporary.}
}
\description{
Sets the specified user's password in a user pool as an administrator. Works on any user.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_set_user_password/} for full documentation.
}
\keyword{internal}
