# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include macie2_service.R
NULL

#' Accepts an Amazon Macie membership invitation that was received from a
#' specific account
#'
#' @description
#' Accepts an Amazon Macie membership invitation that was received from a specific account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_accept_invitation/](https://www.paws-r-sdk.com/docs/macie2_accept_invitation/) for full documentation.
#'
#' @param administratorAccountId The Amazon Web Services account ID for the account that sent the
#' invitation.
#' @param invitationId &#91;required&#93; The unique identifier for the invitation to accept.
#' @param masterAccount (Deprecated) The Amazon Web Services account ID for the account that
#' sent the invitation. This property has been replaced by the
#' administratorAccountId property and is retained only for backward
#' compatibility.
#'
#' @keywords internal
#'
#' @rdname macie2_accept_invitation
macie2_accept_invitation <- function(administratorAccountId = NULL, invitationId, masterAccount = NULL) {
  op <- new_operation(
    name = "AcceptInvitation",
    http_method = "POST",
    http_path = "/invitations/accept",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$accept_invitation_input(administratorAccountId = administratorAccountId, invitationId = invitationId, masterAccount = masterAccount)
  output <- .macie2$accept_invitation_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$accept_invitation <- macie2_accept_invitation

#' Retrieves information about one or more custom data identifiers
#'
#' @description
#' Retrieves information about one or more custom data identifiers.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_batch_get_custom_data_identifiers/](https://www.paws-r-sdk.com/docs/macie2_batch_get_custom_data_identifiers/) for full documentation.
#'
#' @param ids An array of custom data identifier IDs, one for each custom data
#' identifier to retrieve information about.
#'
#' @keywords internal
#'
#' @rdname macie2_batch_get_custom_data_identifiers
macie2_batch_get_custom_data_identifiers <- function(ids = NULL) {
  op <- new_operation(
    name = "BatchGetCustomDataIdentifiers",
    http_method = "POST",
    http_path = "/custom-data-identifiers/get",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$batch_get_custom_data_identifiers_input(ids = ids)
  output <- .macie2$batch_get_custom_data_identifiers_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$batch_get_custom_data_identifiers <- macie2_batch_get_custom_data_identifiers

#' Changes the status of automated sensitive data discovery for one or more
#' accounts
#'
#' @description
#' Changes the status of automated sensitive data discovery for one or more accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_batch_update_automated_discovery_accounts/](https://www.paws-r-sdk.com/docs/macie2_batch_update_automated_discovery_accounts/) for full documentation.
#'
#' @param accounts An array of objects, one for each account to change the status of
#' automated sensitive data discovery for. Each object specifies the Amazon
#' Web Services account ID for an account and a new status for that
#' account.
#'
#' @keywords internal
#'
#' @rdname macie2_batch_update_automated_discovery_accounts
macie2_batch_update_automated_discovery_accounts <- function(accounts = NULL) {
  op <- new_operation(
    name = "BatchUpdateAutomatedDiscoveryAccounts",
    http_method = "PATCH",
    http_path = "/automated-discovery/accounts",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$batch_update_automated_discovery_accounts_input(accounts = accounts)
  output <- .macie2$batch_update_automated_discovery_accounts_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$batch_update_automated_discovery_accounts <- macie2_batch_update_automated_discovery_accounts

#' Creates and defines the settings for an allow list
#'
#' @description
#' Creates and defines the settings for an allow list.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_create_allow_list/](https://www.paws-r-sdk.com/docs/macie2_create_allow_list/) for full documentation.
#'
#' @param clientToken &#91;required&#93; A unique, case-sensitive token that you provide to ensure the
#' idempotency of the request.
#' @param criteria &#91;required&#93; The criteria that specify the text or text pattern to ignore. The
#' criteria can be the location and name of an S3 object that lists
#' specific text to ignore (s3WordsList), or a regular expression (regex)
#' that defines a text pattern to ignore.
#' @param description A custom description of the allow list. The description can contain as
#' many as 512 characters.
#' @param name &#91;required&#93; A custom name for the allow list. The name can contain as many as 128
#' characters.
#' @param tags A map of key-value pairs that specifies the tags to associate with the
#' allow list.
#' 
#' An allow list can have a maximum of 50 tags. Each tag consists of a tag
#' key and an associated tag value. The maximum length of a tag key is 128
#' characters. The maximum length of a tag value is 256 characters.
#'
#' @keywords internal
#'
#' @rdname macie2_create_allow_list
macie2_create_allow_list <- function(clientToken, criteria, description = NULL, name, tags = NULL) {
  op <- new_operation(
    name = "CreateAllowList",
    http_method = "POST",
    http_path = "/allow-lists",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$create_allow_list_input(clientToken = clientToken, criteria = criteria, description = description, name = name, tags = tags)
  output <- .macie2$create_allow_list_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$create_allow_list <- macie2_create_allow_list

#' Creates and defines the settings for a classification job
#'
#' @description
#' Creates and defines the settings for a classification job.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_create_classification_job/](https://www.paws-r-sdk.com/docs/macie2_create_classification_job/) for full documentation.
#'
#' @param allowListIds An array of unique identifiers, one for each allow list for the job to
#' use when it analyzes data.
#' @param clientToken &#91;required&#93; A unique, case-sensitive token that you provide to ensure the
#' idempotency of the request.
#' @param customDataIdentifierIds An array of unique identifiers, one for each custom data identifier for
#' the job to use when it analyzes data. To use only managed data
#' identifiers, don't specify a value for this property and specify a value
#' other than NONE for the managedDataIdentifierSelector property.
#' @param description A custom description of the job. The description can contain as many as
#' 200 characters.
#' @param initialRun For a recurring job, specifies whether to analyze all existing, eligible
#' objects immediately after the job is created (true). To analyze only
#' those objects that are created or changed after you create the job and
#' before the job's first scheduled run, set this value to false.
#' 
#' If you configure the job to run only once, don't specify a value for
#' this property.
#' @param jobType &#91;required&#93; The schedule for running the job. Valid values are:
#' 
#' -   ONE_TIME - Run the job only once. If you specify this value, don't
#'     specify a value for the scheduleFrequency property.
#' 
#' -   SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you
#'     specify this value, use the scheduleFrequency property to specify
#'     the recurrence pattern for the job.
#' @param managedDataIdentifierIds An array of unique identifiers, one for each managed data identifier for
#' the job to include (use) or exclude (not use) when it analyzes data.
#' Inclusion or exclusion depends on the managed data identifier selection
#' type that you specify for the job (managedDataIdentifierSelector).
#' 
#' To retrieve a list of valid values for this property, use the
#' ListManagedDataIdentifiers operation.
#' @param managedDataIdentifierSelector The selection type to apply when determining which managed data
#' identifiers the job uses to analyze data. Valid values are:
#' 
#' -   ALL - Use all managed data identifiers. If you specify this value,
#'     don't specify any values for the managedDataIdentifierIds property.
#' 
#' -   EXCLUDE - Use all managed data identifiers except the ones specified
#'     by the managedDataIdentifierIds property.
#' 
#' -   INCLUDE - Use only the managed data identifiers specified by the
#'     managedDataIdentifierIds property.
#' 
#' -   NONE - Don't use any managed data identifiers. If you specify this
#'     value, specify at least one value for the customDataIdentifierIds
#'     property and don't specify any values for the
#'     managedDataIdentifierIds property.
#' 
#' -   RECOMMENDED (default) - Use the recommended set of managed data
#'     identifiers. If you specify this value, don't specify any values for
#'     the managedDataIdentifierIds property.
#' 
#' If you don't specify a value for this property, the job uses the
#' recommended set of managed data identifiers.
#' 
#' If the job is a recurring job and you specify ALL or EXCLUDE, each job
#' run automatically uses new managed data identifiers that are released.
#' If you don't specify a value for this property or you specify
#' RECOMMENDED for a recurring job, each job run automatically uses all the
#' managed data identifiers that are in the recommended set when the run
#' starts.
#' 
#' To learn about individual managed data identifiers or determine which
#' ones are in the recommended set, see [Using managed data
#' identifiers](https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html)
#' or [Recommended managed data
#' identifiers](https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-mdis-recommended.html)
#' in the *Amazon Macie User Guide*.
#' @param name &#91;required&#93; A custom name for the job. The name can contain as many as 500
#' characters.
#' @param s3JobDefinition &#91;required&#93; The S3 buckets that contain the objects to analyze, and the scope of
#' that analysis.
#' @param samplingPercentage The sampling depth, as a percentage, for the job to apply when
#' processing objects. This value determines the percentage of eligible
#' objects that the job analyzes. If this value is less than 100, Amazon
#' Macie selects the objects to analyze at random, up to the specified
#' percentage, and analyzes all the data in those objects.
#' @param scheduleFrequency The recurrence pattern for running the job. To run the job only once,
#' don't specify a value for this property and set the value for the
#' jobType property to ONE_TIME.
#' @param tags A map of key-value pairs that specifies the tags to associate with the
#' job.
#' 
#' A job can have a maximum of 50 tags. Each tag consists of a tag key and
#' an associated tag value. The maximum length of a tag key is 128
#' characters. The maximum length of a tag value is 256 characters.
#'
#' @keywords internal
#'
#' @rdname macie2_create_classification_job
macie2_create_classification_job <- function(allowListIds = NULL, clientToken, customDataIdentifierIds = NULL, description = NULL, initialRun = NULL, jobType, managedDataIdentifierIds = NULL, managedDataIdentifierSelector = NULL, name, s3JobDefinition, samplingPercentage = NULL, scheduleFrequency = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateClassificationJob",
    http_method = "POST",
    http_path = "/jobs",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$create_classification_job_input(allowListIds = allowListIds, clientToken = clientToken, customDataIdentifierIds = customDataIdentifierIds, description = description, initialRun = initialRun, jobType = jobType, managedDataIdentifierIds = managedDataIdentifierIds, managedDataIdentifierSelector = managedDataIdentifierSelector, name = name, s3JobDefinition = s3JobDefinition, samplingPercentage = samplingPercentage, scheduleFrequency = scheduleFrequency, tags = tags)
  output <- .macie2$create_classification_job_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$create_classification_job <- macie2_create_classification_job

#' Creates and defines the criteria and other settings for a custom data
#' identifier
#'
#' @description
#' Creates and defines the criteria and other settings for a custom data identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_create_custom_data_identifier/](https://www.paws-r-sdk.com/docs/macie2_create_custom_data_identifier/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive token that you provide to ensure the
#' idempotency of the request.
#' @param description A custom description of the custom data identifier. The description can
#' contain as many as 512 characters.
#' 
#' We strongly recommend that you avoid including any sensitive data in the
#' description of a custom data identifier. Other users of your account
#' might be able to see this description, depending on the actions that
#' they're allowed to perform in Amazon Macie.
#' @param ignoreWords An array that lists specific character sequences (*ignore words*) to
#' exclude from the results. If the text matched by the regular expression
#' contains any string in this array, Amazon Macie ignores it. The array
#' can contain as many as 10 ignore words. Each ignore word can contain
#' 4-90 UTF-8 characters. Ignore words are case sensitive.
#' @param keywords An array that lists specific character sequences (*keywords*), one of
#' which must precede and be within proximity (maximumMatchDistance) of the
#' regular expression to match. The array can contain as many as 50
#' keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords
#' aren't case sensitive.
#' @param maximumMatchDistance The maximum number of characters that can exist between the end of at
#' least one complete character sequence specified by the keywords array
#' and the end of the text that matches the regex pattern. If a complete
#' keyword precedes all the text that matches the pattern and the keyword
#' is within the specified distance, Amazon Macie includes the result. The
#' distance can be 1-300 characters. The default value is 50.
#' @param name &#91;required&#93; A custom name for the custom data identifier. The name can contain as
#' many as 128 characters.
#' 
#' We strongly recommend that you avoid including any sensitive data in the
#' name of a custom data identifier. Other users of your account might be
#' able to see this name, depending on the actions that they're allowed to
#' perform in Amazon Macie.
#' @param regex &#91;required&#93; The regular expression (*regex*) that defines the pattern to match. The
#' expression can contain as many as 512 characters.
#' @param severityLevels The severity to assign to findings that the custom data identifier
#' produces, based on the number of occurrences of text that match the
#' custom data identifier's detection criteria. You can specify as many as
#' three SeverityLevel objects in this array, one for each severity: LOW,
#' MEDIUM, or HIGH. If you specify more than one, the occurrences
#' thresholds must be in ascending order by severity, moving from LOW to
#' HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3
#' object contains fewer occurrences than the lowest specified threshold,
#' Amazon Macie doesn't create a finding.
#' 
#' If you don't specify any values for this array, Macie creates findings
#' for S3 objects that contain at least one occurrence of text that matches
#' the detection criteria, and Macie assigns the MEDIUM severity to those
#' findings.
#' @param tags A map of key-value pairs that specifies the tags to associate with the
#' custom data identifier.
#' 
#' A custom data identifier can have a maximum of 50 tags. Each tag
#' consists of a tag key and an associated tag value. The maximum length of
#' a tag key is 128 characters. The maximum length of a tag value is 256
#' characters.
#'
#' @keywords internal
#'
#' @rdname macie2_create_custom_data_identifier
macie2_create_custom_data_identifier <- function(clientToken = NULL, description = NULL, ignoreWords = NULL, keywords = NULL, maximumMatchDistance = NULL, name, regex, severityLevels = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateCustomDataIdentifier",
    http_method = "POST",
    http_path = "/custom-data-identifiers",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$create_custom_data_identifier_input(clientToken = clientToken, description = description, ignoreWords = ignoreWords, keywords = keywords, maximumMatchDistance = maximumMatchDistance, name = name, regex = regex, severityLevels = severityLevels, tags = tags)
  output <- .macie2$create_custom_data_identifier_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$create_custom_data_identifier <- macie2_create_custom_data_identifier

#' Creates and defines the criteria and other settings for a findings
#' filter
#'
#' @description
#' Creates and defines the criteria and other settings for a findings filter.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_create_findings_filter/](https://www.paws-r-sdk.com/docs/macie2_create_findings_filter/) for full documentation.
#'
#' @param action &#91;required&#93; The action to perform on findings that match the filter criteria
#' (findingCriteria). Valid values are: ARCHIVE, suppress (automatically
#' archive) the findings; and, NOOP, don't perform any action on the
#' findings.
#' @param clientToken A unique, case-sensitive token that you provide to ensure the
#' idempotency of the request.
#' @param description A custom description of the filter. The description can contain as many
#' as 512 characters.
#' 
#' We strongly recommend that you avoid including any sensitive data in the
#' description of a filter. Other users of your account might be able to
#' see this description, depending on the actions that they're allowed to
#' perform in Amazon Macie.
#' @param findingCriteria &#91;required&#93; The criteria to use to filter findings.
#' @param name &#91;required&#93; A custom name for the filter. The name must contain at least 3
#' characters and can contain as many as 64 characters.
#' 
#' We strongly recommend that you avoid including any sensitive data in the
#' name of a filter. Other users of your account might be able to see this
#' name, depending on the actions that they're allowed to perform in Amazon
#' Macie.
#' @param position The position of the filter in the list of saved filters on the Amazon
#' Macie console. This value also determines the order in which the filter
#' is applied to findings, relative to other filters that are also applied
#' to the findings.
#' @param tags A map of key-value pairs that specifies the tags to associate with the
#' filter.
#' 
#' A findings filter can have a maximum of 50 tags. Each tag consists of a
#' tag key and an associated tag value. The maximum length of a tag key is
#' 128 characters. The maximum length of a tag value is 256 characters.
#'
#' @keywords internal
#'
#' @rdname macie2_create_findings_filter
macie2_create_findings_filter <- function(action, clientToken = NULL, description = NULL, findingCriteria, name, position = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateFindingsFilter",
    http_method = "POST",
    http_path = "/findingsfilters",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$create_findings_filter_input(action = action, clientToken = clientToken, description = description, findingCriteria = findingCriteria, name = name, position = position, tags = tags)
  output <- .macie2$create_findings_filter_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$create_findings_filter <- macie2_create_findings_filter

#' Sends an Amazon Macie membership invitation to one or more accounts
#'
#' @description
#' Sends an Amazon Macie membership invitation to one or more accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_create_invitations/](https://www.paws-r-sdk.com/docs/macie2_create_invitations/) for full documentation.
#'
#' @param accountIds &#91;required&#93; An array that lists Amazon Web Services account IDs, one for each
#' account to send the invitation to.
#' @param disableEmailNotification Specifies whether to send the invitation as an email message. If this
#' value is false, Amazon Macie sends the invitation (as an email message)
#' to the email address that you specified for the recipient's account when
#' you associated the account with your account. The default value is
#' false.
#' @param message Custom text to include in the email message that contains the
#' invitation. The text can contain as many as 80 alphanumeric characters.
#'
#' @keywords internal
#'
#' @rdname macie2_create_invitations
macie2_create_invitations <- function(accountIds, disableEmailNotification = NULL, message = NULL) {
  op <- new_operation(
    name = "CreateInvitations",
    http_method = "POST",
    http_path = "/invitations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$create_invitations_input(accountIds = accountIds, disableEmailNotification = disableEmailNotification, message = message)
  output <- .macie2$create_invitations_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$create_invitations <- macie2_create_invitations

#' Associates an account with an Amazon Macie administrator account
#'
#' @description
#' Associates an account with an Amazon Macie administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_create_member/](https://www.paws-r-sdk.com/docs/macie2_create_member/) for full documentation.
#'
#' @param account &#91;required&#93; The details of the account to associate with the administrator account.
#' @param tags A map of key-value pairs that specifies the tags to associate with the
#' account in Amazon Macie.
#' 
#' An account can have a maximum of 50 tags. Each tag consists of a tag key
#' and an associated tag value. The maximum length of a tag key is 128
#' characters. The maximum length of a tag value is 256 characters.
#'
#' @keywords internal
#'
#' @rdname macie2_create_member
macie2_create_member <- function(account, tags = NULL) {
  op <- new_operation(
    name = "CreateMember",
    http_method = "POST",
    http_path = "/members",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$create_member_input(account = account, tags = tags)
  output <- .macie2$create_member_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$create_member <- macie2_create_member

#' Creates sample findings
#'
#' @description
#' Creates sample findings.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_create_sample_findings/](https://www.paws-r-sdk.com/docs/macie2_create_sample_findings/) for full documentation.
#'
#' @param findingTypes An array of finding types, one for each type of sample finding to
#' create. To create a sample of every type of finding that Amazon Macie
#' supports, don't include this array in your request.
#'
#' @keywords internal
#'
#' @rdname macie2_create_sample_findings
macie2_create_sample_findings <- function(findingTypes = NULL) {
  op <- new_operation(
    name = "CreateSampleFindings",
    http_method = "POST",
    http_path = "/findings/sample",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$create_sample_findings_input(findingTypes = findingTypes)
  output <- .macie2$create_sample_findings_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$create_sample_findings <- macie2_create_sample_findings

#' Declines Amazon Macie membership invitations that were received from
#' specific accounts
#'
#' @description
#' Declines Amazon Macie membership invitations that were received from specific accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_decline_invitations/](https://www.paws-r-sdk.com/docs/macie2_decline_invitations/) for full documentation.
#'
#' @param accountIds &#91;required&#93; An array that lists Amazon Web Services account IDs, one for each
#' account that sent an invitation to decline.
#'
#' @keywords internal
#'
#' @rdname macie2_decline_invitations
macie2_decline_invitations <- function(accountIds) {
  op <- new_operation(
    name = "DeclineInvitations",
    http_method = "POST",
    http_path = "/invitations/decline",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$decline_invitations_input(accountIds = accountIds)
  output <- .macie2$decline_invitations_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$decline_invitations <- macie2_decline_invitations

#' Deletes an allow list
#'
#' @description
#' Deletes an allow list.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_delete_allow_list/](https://www.paws-r-sdk.com/docs/macie2_delete_allow_list/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#' @param ignoreJobChecks Specifies whether to force deletion of the allow list, even if active
#' classification jobs are configured to use the list.
#' 
#' When you try to delete an allow list, Amazon Macie checks for
#' classification jobs that use the list and have a status other than
#' COMPLETE or CANCELLED. By default, Macie rejects your request if any
#' jobs meet these criteria. To skip these checks and delete the list, set
#' this value to true. To delete the list only if no active jobs are
#' configured to use it, set this value to false.
#'
#' @keywords internal
#'
#' @rdname macie2_delete_allow_list
macie2_delete_allow_list <- function(id, ignoreJobChecks = NULL) {
  op <- new_operation(
    name = "DeleteAllowList",
    http_method = "DELETE",
    http_path = "/allow-lists/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$delete_allow_list_input(id = id, ignoreJobChecks = ignoreJobChecks)
  output <- .macie2$delete_allow_list_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$delete_allow_list <- macie2_delete_allow_list

#' Soft deletes a custom data identifier
#'
#' @description
#' Soft deletes a custom data identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_delete_custom_data_identifier/](https://www.paws-r-sdk.com/docs/macie2_delete_custom_data_identifier/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#'
#' @keywords internal
#'
#' @rdname macie2_delete_custom_data_identifier
macie2_delete_custom_data_identifier <- function(id) {
  op <- new_operation(
    name = "DeleteCustomDataIdentifier",
    http_method = "DELETE",
    http_path = "/custom-data-identifiers/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$delete_custom_data_identifier_input(id = id)
  output <- .macie2$delete_custom_data_identifier_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$delete_custom_data_identifier <- macie2_delete_custom_data_identifier

#' Deletes a findings filter
#'
#' @description
#' Deletes a findings filter.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_delete_findings_filter/](https://www.paws-r-sdk.com/docs/macie2_delete_findings_filter/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#'
#' @keywords internal
#'
#' @rdname macie2_delete_findings_filter
macie2_delete_findings_filter <- function(id) {
  op <- new_operation(
    name = "DeleteFindingsFilter",
    http_method = "DELETE",
    http_path = "/findingsfilters/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$delete_findings_filter_input(id = id)
  output <- .macie2$delete_findings_filter_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$delete_findings_filter <- macie2_delete_findings_filter

#' Deletes Amazon Macie membership invitations that were received from
#' specific accounts
#'
#' @description
#' Deletes Amazon Macie membership invitations that were received from specific accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_delete_invitations/](https://www.paws-r-sdk.com/docs/macie2_delete_invitations/) for full documentation.
#'
#' @param accountIds &#91;required&#93; An array that lists Amazon Web Services account IDs, one for each
#' account that sent an invitation to delete.
#'
#' @keywords internal
#'
#' @rdname macie2_delete_invitations
macie2_delete_invitations <- function(accountIds) {
  op <- new_operation(
    name = "DeleteInvitations",
    http_method = "POST",
    http_path = "/invitations/delete",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$delete_invitations_input(accountIds = accountIds)
  output <- .macie2$delete_invitations_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$delete_invitations <- macie2_delete_invitations

#' Deletes the association between an Amazon Macie administrator account
#' and an account
#'
#' @description
#' Deletes the association between an Amazon Macie administrator account and an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_delete_member/](https://www.paws-r-sdk.com/docs/macie2_delete_member/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#'
#' @keywords internal
#'
#' @rdname macie2_delete_member
macie2_delete_member <- function(id) {
  op <- new_operation(
    name = "DeleteMember",
    http_method = "DELETE",
    http_path = "/members/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$delete_member_input(id = id)
  output <- .macie2$delete_member_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$delete_member <- macie2_delete_member

#' Retrieves (queries) statistical data and other information about one or
#' more S3 buckets that Amazon Macie monitors and analyzes for an account
#'
#' @description
#' Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie monitors and analyzes for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_describe_buckets/](https://www.paws-r-sdk.com/docs/macie2_describe_buckets/) for full documentation.
#'
#' @param criteria The criteria to use to filter the query results.
#' @param maxResults The maximum number of items to include in each page of the response. The
#' default value is 50.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#' @param sortCriteria The criteria to use to sort the query results.
#'
#' @keywords internal
#'
#' @rdname macie2_describe_buckets
macie2_describe_buckets <- function(criteria = NULL, maxResults = NULL, nextToken = NULL, sortCriteria = NULL) {
  op <- new_operation(
    name = "DescribeBuckets",
    http_method = "POST",
    http_path = "/datasources/s3",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "buckets"),
    stream_api = FALSE
  )
  input <- .macie2$describe_buckets_input(criteria = criteria, maxResults = maxResults, nextToken = nextToken, sortCriteria = sortCriteria)
  output <- .macie2$describe_buckets_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$describe_buckets <- macie2_describe_buckets

#' Retrieves the status and settings for a classification job
#'
#' @description
#' Retrieves the status and settings for a classification job.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_describe_classification_job/](https://www.paws-r-sdk.com/docs/macie2_describe_classification_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The unique identifier for the classification job.
#'
#' @keywords internal
#'
#' @rdname macie2_describe_classification_job
macie2_describe_classification_job <- function(jobId) {
  op <- new_operation(
    name = "DescribeClassificationJob",
    http_method = "GET",
    http_path = "/jobs/{jobId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$describe_classification_job_input(jobId = jobId)
  output <- .macie2$describe_classification_job_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$describe_classification_job <- macie2_describe_classification_job

#' Retrieves the Amazon Macie configuration settings for an organization in
#' Organizations
#'
#' @description
#' Retrieves the Amazon Macie configuration settings for an organization in Organizations.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_describe_organization_configuration/](https://www.paws-r-sdk.com/docs/macie2_describe_organization_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname macie2_describe_organization_configuration
macie2_describe_organization_configuration <- function() {
  op <- new_operation(
    name = "DescribeOrganizationConfiguration",
    http_method = "GET",
    http_path = "/admin/configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$describe_organization_configuration_input()
  output <- .macie2$describe_organization_configuration_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$describe_organization_configuration <- macie2_describe_organization_configuration

#' Disables Amazon Macie and deletes all settings and resources for a Macie
#' account
#'
#' @description
#' Disables Amazon Macie and deletes all settings and resources for a Macie account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_disable_macie/](https://www.paws-r-sdk.com/docs/macie2_disable_macie/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname macie2_disable_macie
macie2_disable_macie <- function() {
  op <- new_operation(
    name = "DisableMacie",
    http_method = "DELETE",
    http_path = "/macie",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$disable_macie_input()
  output <- .macie2$disable_macie_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$disable_macie <- macie2_disable_macie

#' Disables an account as the delegated Amazon Macie administrator account
#' for an organization in Organizations
#'
#' @description
#' Disables an account as the delegated Amazon Macie administrator account for an organization in Organizations.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_disable_organization_admin_account/](https://www.paws-r-sdk.com/docs/macie2_disable_organization_admin_account/) for full documentation.
#'
#' @param adminAccountId &#91;required&#93; The Amazon Web Services account ID of the delegated Amazon Macie
#' administrator account.
#'
#' @keywords internal
#'
#' @rdname macie2_disable_organization_admin_account
macie2_disable_organization_admin_account <- function(adminAccountId) {
  op <- new_operation(
    name = "DisableOrganizationAdminAccount",
    http_method = "DELETE",
    http_path = "/admin",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$disable_organization_admin_account_input(adminAccountId = adminAccountId)
  output <- .macie2$disable_organization_admin_account_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$disable_organization_admin_account <- macie2_disable_organization_admin_account

#' Disassociates a member account from its Amazon Macie administrator
#' account
#'
#' @description
#' Disassociates a member account from its Amazon Macie administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_disassociate_from_administrator_account/](https://www.paws-r-sdk.com/docs/macie2_disassociate_from_administrator_account/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname macie2_disassociate_from_administrator_account
macie2_disassociate_from_administrator_account <- function() {
  op <- new_operation(
    name = "DisassociateFromAdministratorAccount",
    http_method = "POST",
    http_path = "/administrator/disassociate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$disassociate_from_administrator_account_input()
  output <- .macie2$disassociate_from_administrator_account_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$disassociate_from_administrator_account <- macie2_disassociate_from_administrator_account

#' (Deprecated) Disassociates a member account from its Amazon Macie
#' administrator account
#'
#' @description
#' (Deprecated) Disassociates a member account from its Amazon Macie administrator account. This operation has been replaced by the DisassociateFromAdministratorAccount operation.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_disassociate_from_master_account/](https://www.paws-r-sdk.com/docs/macie2_disassociate_from_master_account/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname macie2_disassociate_from_master_account
macie2_disassociate_from_master_account <- function() {
  op <- new_operation(
    name = "DisassociateFromMasterAccount",
    http_method = "POST",
    http_path = "/master/disassociate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$disassociate_from_master_account_input()
  output <- .macie2$disassociate_from_master_account_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$disassociate_from_master_account <- macie2_disassociate_from_master_account

#' Disassociates an Amazon Macie administrator account from a member
#' account
#'
#' @description
#' Disassociates an Amazon Macie administrator account from a member account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_disassociate_member/](https://www.paws-r-sdk.com/docs/macie2_disassociate_member/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#'
#' @keywords internal
#'
#' @rdname macie2_disassociate_member
macie2_disassociate_member <- function(id) {
  op <- new_operation(
    name = "DisassociateMember",
    http_method = "POST",
    http_path = "/members/disassociate/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$disassociate_member_input(id = id)
  output <- .macie2$disassociate_member_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$disassociate_member <- macie2_disassociate_member

#' Enables Amazon Macie and specifies the configuration settings for a
#' Macie account
#'
#' @description
#' Enables Amazon Macie and specifies the configuration settings for a Macie account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_enable_macie/](https://www.paws-r-sdk.com/docs/macie2_enable_macie/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive token that you provide to ensure the
#' idempotency of the request.
#' @param findingPublishingFrequency Specifies how often to publish updates to policy findings for the
#' account. This includes publishing updates to Security Hub and Amazon
#' EventBridge (formerly Amazon CloudWatch Events).
#' @param status Specifies the new status for the account. To enable Amazon Macie and
#' start all Macie activities for the account, set this value to ENABLED.
#'
#' @keywords internal
#'
#' @rdname macie2_enable_macie
macie2_enable_macie <- function(clientToken = NULL, findingPublishingFrequency = NULL, status = NULL) {
  op <- new_operation(
    name = "EnableMacie",
    http_method = "POST",
    http_path = "/macie",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$enable_macie_input(clientToken = clientToken, findingPublishingFrequency = findingPublishingFrequency, status = status)
  output <- .macie2$enable_macie_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$enable_macie <- macie2_enable_macie

#' Designates an account as the delegated Amazon Macie administrator
#' account for an organization in Organizations
#'
#' @description
#' Designates an account as the delegated Amazon Macie administrator account for an organization in Organizations.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_enable_organization_admin_account/](https://www.paws-r-sdk.com/docs/macie2_enable_organization_admin_account/) for full documentation.
#'
#' @param adminAccountId &#91;required&#93; The Amazon Web Services account ID for the account to designate as the
#' delegated Amazon Macie administrator account for the organization.
#' @param clientToken A unique, case-sensitive token that you provide to ensure the
#' idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname macie2_enable_organization_admin_account
macie2_enable_organization_admin_account <- function(adminAccountId, clientToken = NULL) {
  op <- new_operation(
    name = "EnableOrganizationAdminAccount",
    http_method = "POST",
    http_path = "/admin",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$enable_organization_admin_account_input(adminAccountId = adminAccountId, clientToken = clientToken)
  output <- .macie2$enable_organization_admin_account_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$enable_organization_admin_account <- macie2_enable_organization_admin_account

#' Retrieves information about the Amazon Macie administrator account for
#' an account
#'
#' @description
#' Retrieves information about the Amazon Macie administrator account for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_administrator_account/](https://www.paws-r-sdk.com/docs/macie2_get_administrator_account/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname macie2_get_administrator_account
macie2_get_administrator_account <- function() {
  op <- new_operation(
    name = "GetAdministratorAccount",
    http_method = "GET",
    http_path = "/administrator",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_administrator_account_input()
  output <- .macie2$get_administrator_account_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_administrator_account <- macie2_get_administrator_account

#' Retrieves the settings and status of an allow list
#'
#' @description
#' Retrieves the settings and status of an allow list.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_allow_list/](https://www.paws-r-sdk.com/docs/macie2_get_allow_list/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#'
#' @keywords internal
#'
#' @rdname macie2_get_allow_list
macie2_get_allow_list <- function(id) {
  op <- new_operation(
    name = "GetAllowList",
    http_method = "GET",
    http_path = "/allow-lists/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_allow_list_input(id = id)
  output <- .macie2$get_allow_list_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_allow_list <- macie2_get_allow_list

#' Retrieves the configuration settings and status of automated sensitive
#' data discovery for an organization or standalone account
#'
#' @description
#' Retrieves the configuration settings and status of automated sensitive data discovery for an organization or standalone account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_automated_discovery_configuration/](https://www.paws-r-sdk.com/docs/macie2_get_automated_discovery_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname macie2_get_automated_discovery_configuration
macie2_get_automated_discovery_configuration <- function() {
  op <- new_operation(
    name = "GetAutomatedDiscoveryConfiguration",
    http_method = "GET",
    http_path = "/automated-discovery/configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_automated_discovery_configuration_input()
  output <- .macie2$get_automated_discovery_configuration_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_automated_discovery_configuration <- macie2_get_automated_discovery_configuration

#' Retrieves (queries) aggregated statistical data about all the S3 buckets
#' that Amazon Macie monitors and analyzes for an account
#'
#' @description
#' Retrieves (queries) aggregated statistical data about all the S3 buckets that Amazon Macie monitors and analyzes for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_bucket_statistics/](https://www.paws-r-sdk.com/docs/macie2_get_bucket_statistics/) for full documentation.
#'
#' @param accountId The unique identifier for the Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname macie2_get_bucket_statistics
macie2_get_bucket_statistics <- function(accountId = NULL) {
  op <- new_operation(
    name = "GetBucketStatistics",
    http_method = "POST",
    http_path = "/datasources/s3/statistics",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_bucket_statistics_input(accountId = accountId)
  output <- .macie2$get_bucket_statistics_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_bucket_statistics <- macie2_get_bucket_statistics

#' Retrieves the configuration settings for storing data classification
#' results
#'
#' @description
#' Retrieves the configuration settings for storing data classification results.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_classification_export_configuration/](https://www.paws-r-sdk.com/docs/macie2_get_classification_export_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname macie2_get_classification_export_configuration
macie2_get_classification_export_configuration <- function() {
  op <- new_operation(
    name = "GetClassificationExportConfiguration",
    http_method = "GET",
    http_path = "/classification-export-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_classification_export_configuration_input()
  output <- .macie2$get_classification_export_configuration_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_classification_export_configuration <- macie2_get_classification_export_configuration

#' Retrieves the classification scope settings for an account
#'
#' @description
#' Retrieves the classification scope settings for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_classification_scope/](https://www.paws-r-sdk.com/docs/macie2_get_classification_scope/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#'
#' @keywords internal
#'
#' @rdname macie2_get_classification_scope
macie2_get_classification_scope <- function(id) {
  op <- new_operation(
    name = "GetClassificationScope",
    http_method = "GET",
    http_path = "/classification-scopes/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_classification_scope_input(id = id)
  output <- .macie2$get_classification_scope_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_classification_scope <- macie2_get_classification_scope

#' Retrieves the criteria and other settings for a custom data identifier
#'
#' @description
#' Retrieves the criteria and other settings for a custom data identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_custom_data_identifier/](https://www.paws-r-sdk.com/docs/macie2_get_custom_data_identifier/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#'
#' @keywords internal
#'
#' @rdname macie2_get_custom_data_identifier
macie2_get_custom_data_identifier <- function(id) {
  op <- new_operation(
    name = "GetCustomDataIdentifier",
    http_method = "GET",
    http_path = "/custom-data-identifiers/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_custom_data_identifier_input(id = id)
  output <- .macie2$get_custom_data_identifier_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_custom_data_identifier <- macie2_get_custom_data_identifier

#' Retrieves (queries) aggregated statistical data about findings
#'
#' @description
#' Retrieves (queries) aggregated statistical data about findings.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_finding_statistics/](https://www.paws-r-sdk.com/docs/macie2_get_finding_statistics/) for full documentation.
#'
#' @param findingCriteria The criteria to use to filter the query results.
#' @param groupBy &#91;required&#93; The finding property to use to group the query results. Valid values
#' are:
#' 
#' -   classificationDetails.jobId - The unique identifier for the
#'     classification job that produced the finding.
#' 
#' -   resourcesAffected.s3Bucket.name - The name of the S3 bucket that the
#'     finding applies to.
#' 
#' -   severity.description - The severity level of the finding, such as
#'     High or Medium.
#' 
#' -   type - The type of finding, such as Policy:IAMUser/S3BucketPublic
#'     and SensitiveData:S3Object/Personal.
#' @param size The maximum number of items to include in each page of the response.
#' @param sortCriteria The criteria to use to sort the query results.
#'
#' @keywords internal
#'
#' @rdname macie2_get_finding_statistics
macie2_get_finding_statistics <- function(findingCriteria = NULL, groupBy, size = NULL, sortCriteria = NULL) {
  op <- new_operation(
    name = "GetFindingStatistics",
    http_method = "POST",
    http_path = "/findings/statistics",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_finding_statistics_input(findingCriteria = findingCriteria, groupBy = groupBy, size = size, sortCriteria = sortCriteria)
  output <- .macie2$get_finding_statistics_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_finding_statistics <- macie2_get_finding_statistics

#' Retrieves the details of one or more findings
#'
#' @description
#' Retrieves the details of one or more findings.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_findings/](https://www.paws-r-sdk.com/docs/macie2_get_findings/) for full documentation.
#'
#' @param findingIds &#91;required&#93; An array of strings that lists the unique identifiers for the findings
#' to retrieve. You can specify as many as 50 unique identifiers in this
#' array.
#' @param sortCriteria The criteria for sorting the results of the request.
#'
#' @keywords internal
#'
#' @rdname macie2_get_findings
macie2_get_findings <- function(findingIds, sortCriteria = NULL) {
  op <- new_operation(
    name = "GetFindings",
    http_method = "POST",
    http_path = "/findings/describe",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_findings_input(findingIds = findingIds, sortCriteria = sortCriteria)
  output <- .macie2$get_findings_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_findings <- macie2_get_findings

#' Retrieves the criteria and other settings for a findings filter
#'
#' @description
#' Retrieves the criteria and other settings for a findings filter.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_findings_filter/](https://www.paws-r-sdk.com/docs/macie2_get_findings_filter/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#'
#' @keywords internal
#'
#' @rdname macie2_get_findings_filter
macie2_get_findings_filter <- function(id) {
  op <- new_operation(
    name = "GetFindingsFilter",
    http_method = "GET",
    http_path = "/findingsfilters/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_findings_filter_input(id = id)
  output <- .macie2$get_findings_filter_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_findings_filter <- macie2_get_findings_filter

#' Retrieves the configuration settings for publishing findings to Security
#' Hub
#'
#' @description
#' Retrieves the configuration settings for publishing findings to Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_findings_publication_configuration/](https://www.paws-r-sdk.com/docs/macie2_get_findings_publication_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname macie2_get_findings_publication_configuration
macie2_get_findings_publication_configuration <- function() {
  op <- new_operation(
    name = "GetFindingsPublicationConfiguration",
    http_method = "GET",
    http_path = "/findings-publication-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_findings_publication_configuration_input()
  output <- .macie2$get_findings_publication_configuration_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_findings_publication_configuration <- macie2_get_findings_publication_configuration

#' Retrieves the count of Amazon Macie membership invitations that were
#' received by an account
#'
#' @description
#' Retrieves the count of Amazon Macie membership invitations that were received by an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_invitations_count/](https://www.paws-r-sdk.com/docs/macie2_get_invitations_count/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname macie2_get_invitations_count
macie2_get_invitations_count <- function() {
  op <- new_operation(
    name = "GetInvitationsCount",
    http_method = "GET",
    http_path = "/invitations/count",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_invitations_count_input()
  output <- .macie2$get_invitations_count_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_invitations_count <- macie2_get_invitations_count

#' Retrieves the status and configuration settings for an Amazon Macie
#' account
#'
#' @description
#' Retrieves the status and configuration settings for an Amazon Macie account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_macie_session/](https://www.paws-r-sdk.com/docs/macie2_get_macie_session/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname macie2_get_macie_session
macie2_get_macie_session <- function() {
  op <- new_operation(
    name = "GetMacieSession",
    http_method = "GET",
    http_path = "/macie",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_macie_session_input()
  output <- .macie2$get_macie_session_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_macie_session <- macie2_get_macie_session

#' (Deprecated) Retrieves information about the Amazon Macie administrator
#' account for an account
#'
#' @description
#' (Deprecated) Retrieves information about the Amazon Macie administrator account for an account. This operation has been replaced by the GetAdministratorAccount operation.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_master_account/](https://www.paws-r-sdk.com/docs/macie2_get_master_account/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname macie2_get_master_account
macie2_get_master_account <- function() {
  op <- new_operation(
    name = "GetMasterAccount",
    http_method = "GET",
    http_path = "/master",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_master_account_input()
  output <- .macie2$get_master_account_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_master_account <- macie2_get_master_account

#' Retrieves information about an account that's associated with an Amazon
#' Macie administrator account
#'
#' @description
#' Retrieves information about an account that's associated with an Amazon Macie administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_member/](https://www.paws-r-sdk.com/docs/macie2_get_member/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#'
#' @keywords internal
#'
#' @rdname macie2_get_member
macie2_get_member <- function(id) {
  op <- new_operation(
    name = "GetMember",
    http_method = "GET",
    http_path = "/members/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_member_input(id = id)
  output <- .macie2$get_member_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_member <- macie2_get_member

#' Retrieves (queries) sensitive data discovery statistics and the
#' sensitivity score for an S3 bucket
#'
#' @description
#' Retrieves (queries) sensitive data discovery statistics and the sensitivity score for an S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_resource_profile/](https://www.paws-r-sdk.com/docs/macie2_get_resource_profile/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the S3 bucket that the request applies
#' to.
#'
#' @keywords internal
#'
#' @rdname macie2_get_resource_profile
macie2_get_resource_profile <- function(resourceArn) {
  op <- new_operation(
    name = "GetResourceProfile",
    http_method = "GET",
    http_path = "/resource-profiles",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_resource_profile_input(resourceArn = resourceArn)
  output <- .macie2$get_resource_profile_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_resource_profile <- macie2_get_resource_profile

#' Retrieves the status and configuration settings for retrieving
#' occurrences of sensitive data reported by findings
#'
#' @description
#' Retrieves the status and configuration settings for retrieving occurrences of sensitive data reported by findings.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_reveal_configuration/](https://www.paws-r-sdk.com/docs/macie2_get_reveal_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname macie2_get_reveal_configuration
macie2_get_reveal_configuration <- function() {
  op <- new_operation(
    name = "GetRevealConfiguration",
    http_method = "GET",
    http_path = "/reveal-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_reveal_configuration_input()
  output <- .macie2$get_reveal_configuration_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_reveal_configuration <- macie2_get_reveal_configuration

#' Retrieves occurrences of sensitive data reported by a finding
#'
#' @description
#' Retrieves occurrences of sensitive data reported by a finding.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_sensitive_data_occurrences/](https://www.paws-r-sdk.com/docs/macie2_get_sensitive_data_occurrences/) for full documentation.
#'
#' @param findingId &#91;required&#93; The unique identifier for the finding.
#'
#' @keywords internal
#'
#' @rdname macie2_get_sensitive_data_occurrences
macie2_get_sensitive_data_occurrences <- function(findingId) {
  op <- new_operation(
    name = "GetSensitiveDataOccurrences",
    http_method = "GET",
    http_path = "/findings/{findingId}/reveal",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_sensitive_data_occurrences_input(findingId = findingId)
  output <- .macie2$get_sensitive_data_occurrences_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_sensitive_data_occurrences <- macie2_get_sensitive_data_occurrences

#' Checks whether occurrences of sensitive data can be retrieved for a
#' finding
#'
#' @description
#' Checks whether occurrences of sensitive data can be retrieved for a finding.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_sensitive_data_occurrences_availability/](https://www.paws-r-sdk.com/docs/macie2_get_sensitive_data_occurrences_availability/) for full documentation.
#'
#' @param findingId &#91;required&#93; The unique identifier for the finding.
#'
#' @keywords internal
#'
#' @rdname macie2_get_sensitive_data_occurrences_availability
macie2_get_sensitive_data_occurrences_availability <- function(findingId) {
  op <- new_operation(
    name = "GetSensitiveDataOccurrencesAvailability",
    http_method = "GET",
    http_path = "/findings/{findingId}/reveal/availability",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_sensitive_data_occurrences_availability_input(findingId = findingId)
  output <- .macie2$get_sensitive_data_occurrences_availability_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_sensitive_data_occurrences_availability <- macie2_get_sensitive_data_occurrences_availability

#' Retrieves the settings for the sensitivity inspection template for an
#' account
#'
#' @description
#' Retrieves the settings for the sensitivity inspection template for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_sensitivity_inspection_template/](https://www.paws-r-sdk.com/docs/macie2_get_sensitivity_inspection_template/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#'
#' @keywords internal
#'
#' @rdname macie2_get_sensitivity_inspection_template
macie2_get_sensitivity_inspection_template <- function(id) {
  op <- new_operation(
    name = "GetSensitivityInspectionTemplate",
    http_method = "GET",
    http_path = "/templates/sensitivity-inspections/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_sensitivity_inspection_template_input(id = id)
  output <- .macie2$get_sensitivity_inspection_template_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_sensitivity_inspection_template <- macie2_get_sensitivity_inspection_template

#' Retrieves (queries) quotas and aggregated usage data for one or more
#' accounts
#'
#' @description
#' Retrieves (queries) quotas and aggregated usage data for one or more accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_usage_statistics/](https://www.paws-r-sdk.com/docs/macie2_get_usage_statistics/) for full documentation.
#'
#' @param filterBy An array of objects, one for each condition to use to filter the query
#' results. If you specify more than one condition, Amazon Macie uses an
#' AND operator to join the conditions.
#' @param maxResults The maximum number of items to include in each page of the response.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#' @param sortBy The criteria to use to sort the query results.
#' @param timeRange The inclusive time period to query usage data for. Valid values are:
#' MONTH_TO_DATE, for the current calendar month to date; and,
#' PAST_30_DAYS, for the preceding 30 days. If you don't specify a value,
#' Amazon Macie provides usage data for the preceding 30 days.
#'
#' @keywords internal
#'
#' @rdname macie2_get_usage_statistics
macie2_get_usage_statistics <- function(filterBy = NULL, maxResults = NULL, nextToken = NULL, sortBy = NULL, timeRange = NULL) {
  op <- new_operation(
    name = "GetUsageStatistics",
    http_method = "POST",
    http_path = "/usage/statistics",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "records", non_aggregate_keys = list("timeRange")),
    stream_api = FALSE
  )
  input <- .macie2$get_usage_statistics_input(filterBy = filterBy, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, timeRange = timeRange)
  output <- .macie2$get_usage_statistics_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_usage_statistics <- macie2_get_usage_statistics

#' Retrieves (queries) aggregated usage data for an account
#'
#' @description
#' Retrieves (queries) aggregated usage data for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_get_usage_totals/](https://www.paws-r-sdk.com/docs/macie2_get_usage_totals/) for full documentation.
#'
#' @param timeRange The inclusive time period to retrieve the data for. Valid values are:
#' MONTH_TO_DATE, for the current calendar month to date; and,
#' PAST_30_DAYS, for the preceding 30 days. If you don't specify a value
#' for this parameter, Amazon Macie provides aggregated usage data for the
#' preceding 30 days.
#'
#' @keywords internal
#'
#' @rdname macie2_get_usage_totals
macie2_get_usage_totals <- function(timeRange = NULL) {
  op <- new_operation(
    name = "GetUsageTotals",
    http_method = "GET",
    http_path = "/usage",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$get_usage_totals_input(timeRange = timeRange)
  output <- .macie2$get_usage_totals_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$get_usage_totals <- macie2_get_usage_totals

#' Retrieves a subset of information about all the allow lists for an
#' account
#'
#' @description
#' Retrieves a subset of information about all the allow lists for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_allow_lists/](https://www.paws-r-sdk.com/docs/macie2_list_allow_lists/) for full documentation.
#'
#' @param maxResults The maximum number of items to include in each page of a paginated
#' response.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname macie2_list_allow_lists
macie2_list_allow_lists <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAllowLists",
    http_method = "GET",
    http_path = "/allow-lists",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "allowLists"),
    stream_api = FALSE
  )
  input <- .macie2$list_allow_lists_input(maxResults = maxResults, nextToken = nextToken)
  output <- .macie2$list_allow_lists_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_allow_lists <- macie2_list_allow_lists

#' Retrieves the status of automated sensitive data discovery for one or
#' more accounts
#'
#' @description
#' Retrieves the status of automated sensitive data discovery for one or more accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_automated_discovery_accounts/](https://www.paws-r-sdk.com/docs/macie2_list_automated_discovery_accounts/) for full documentation.
#'
#' @param accountIds The Amazon Web Services account ID for each account, for as many as 50
#' accounts. To retrieve the status for multiple accounts, append the
#' accountIds parameter and argument for each account, separated by an
#' ampersand (&). To retrieve the status for all the accounts in an
#' organization, omit this parameter.
#' @param maxResults The maximum number of items to include in each page of a paginated
#' response.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname macie2_list_automated_discovery_accounts
macie2_list_automated_discovery_accounts <- function(accountIds = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAutomatedDiscoveryAccounts",
    http_method = "GET",
    http_path = "/automated-discovery/accounts",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .macie2$list_automated_discovery_accounts_input(accountIds = accountIds, maxResults = maxResults, nextToken = nextToken)
  output <- .macie2$list_automated_discovery_accounts_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_automated_discovery_accounts <- macie2_list_automated_discovery_accounts

#' Retrieves a subset of information about one or more classification jobs
#'
#' @description
#' Retrieves a subset of information about one or more classification jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_classification_jobs/](https://www.paws-r-sdk.com/docs/macie2_list_classification_jobs/) for full documentation.
#'
#' @param filterCriteria The criteria to use to filter the results.
#' @param maxResults The maximum number of items to include in each page of the response.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#' @param sortCriteria The criteria to use to sort the results.
#'
#' @keywords internal
#'
#' @rdname macie2_list_classification_jobs
macie2_list_classification_jobs <- function(filterCriteria = NULL, maxResults = NULL, nextToken = NULL, sortCriteria = NULL) {
  op <- new_operation(
    name = "ListClassificationJobs",
    http_method = "POST",
    http_path = "/jobs/list",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .macie2$list_classification_jobs_input(filterCriteria = filterCriteria, maxResults = maxResults, nextToken = nextToken, sortCriteria = sortCriteria)
  output <- .macie2$list_classification_jobs_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_classification_jobs <- macie2_list_classification_jobs

#' Retrieves a subset of information about the classification scope for an
#' account
#'
#' @description
#' Retrieves a subset of information about the classification scope for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_classification_scopes/](https://www.paws-r-sdk.com/docs/macie2_list_classification_scopes/) for full documentation.
#'
#' @param name The name of the classification scope to retrieve the unique identifier
#' for.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname macie2_list_classification_scopes
macie2_list_classification_scopes <- function(name = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListClassificationScopes",
    http_method = "GET",
    http_path = "/classification-scopes",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "classificationScopes"),
    stream_api = FALSE
  )
  input <- .macie2$list_classification_scopes_input(name = name, nextToken = nextToken)
  output <- .macie2$list_classification_scopes_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_classification_scopes <- macie2_list_classification_scopes

#' Retrieves a subset of information about the custom data identifiers for
#' an account
#'
#' @description
#' Retrieves a subset of information about the custom data identifiers for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_custom_data_identifiers/](https://www.paws-r-sdk.com/docs/macie2_list_custom_data_identifiers/) for full documentation.
#'
#' @param maxResults The maximum number of items to include in each page of the response.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname macie2_list_custom_data_identifiers
macie2_list_custom_data_identifiers <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListCustomDataIdentifiers",
    http_method = "POST",
    http_path = "/custom-data-identifiers/list",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .macie2$list_custom_data_identifiers_input(maxResults = maxResults, nextToken = nextToken)
  output <- .macie2$list_custom_data_identifiers_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_custom_data_identifiers <- macie2_list_custom_data_identifiers

#' Retrieves a subset of information about one or more findings
#'
#' @description
#' Retrieves a subset of information about one or more findings.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_findings/](https://www.paws-r-sdk.com/docs/macie2_list_findings/) for full documentation.
#'
#' @param findingCriteria The criteria to use to filter the results.
#' @param maxResults The maximum number of items to include in each page of the response.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#' @param sortCriteria The criteria to use to sort the results.
#'
#' @keywords internal
#'
#' @rdname macie2_list_findings
macie2_list_findings <- function(findingCriteria = NULL, maxResults = NULL, nextToken = NULL, sortCriteria = NULL) {
  op <- new_operation(
    name = "ListFindings",
    http_method = "POST",
    http_path = "/findings",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "findingIds"),
    stream_api = FALSE
  )
  input <- .macie2$list_findings_input(findingCriteria = findingCriteria, maxResults = maxResults, nextToken = nextToken, sortCriteria = sortCriteria)
  output <- .macie2$list_findings_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_findings <- macie2_list_findings

#' Retrieves a subset of information about all the findings filters for an
#' account
#'
#' @description
#' Retrieves a subset of information about all the findings filters for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_findings_filters/](https://www.paws-r-sdk.com/docs/macie2_list_findings_filters/) for full documentation.
#'
#' @param maxResults The maximum number of items to include in each page of a paginated
#' response.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname macie2_list_findings_filters
macie2_list_findings_filters <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListFindingsFilters",
    http_method = "GET",
    http_path = "/findingsfilters",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "findingsFilterListItems"),
    stream_api = FALSE
  )
  input <- .macie2$list_findings_filters_input(maxResults = maxResults, nextToken = nextToken)
  output <- .macie2$list_findings_filters_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_findings_filters <- macie2_list_findings_filters

#' Retrieves information about Amazon Macie membership invitations that
#' were received by an account
#'
#' @description
#' Retrieves information about Amazon Macie membership invitations that were received by an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_invitations/](https://www.paws-r-sdk.com/docs/macie2_list_invitations/) for full documentation.
#'
#' @param maxResults The maximum number of items to include in each page of a paginated
#' response.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname macie2_list_invitations
macie2_list_invitations <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListInvitations",
    http_method = "GET",
    http_path = "/invitations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "invitations"),
    stream_api = FALSE
  )
  input <- .macie2$list_invitations_input(maxResults = maxResults, nextToken = nextToken)
  output <- .macie2$list_invitations_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_invitations <- macie2_list_invitations

#' Retrieves information about all the managed data identifiers that Amazon
#' Macie currently provides
#'
#' @description
#' Retrieves information about all the managed data identifiers that Amazon Macie currently provides.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_managed_data_identifiers/](https://www.paws-r-sdk.com/docs/macie2_list_managed_data_identifiers/) for full documentation.
#'
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname macie2_list_managed_data_identifiers
macie2_list_managed_data_identifiers <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListManagedDataIdentifiers",
    http_method = "POST",
    http_path = "/managed-data-identifiers/list",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "items"),
    stream_api = FALSE
  )
  input <- .macie2$list_managed_data_identifiers_input(nextToken = nextToken)
  output <- .macie2$list_managed_data_identifiers_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_managed_data_identifiers <- macie2_list_managed_data_identifiers

#' Retrieves information about the accounts that are associated with an
#' Amazon Macie administrator account
#'
#' @description
#' Retrieves information about the accounts that are associated with an Amazon Macie administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_members/](https://www.paws-r-sdk.com/docs/macie2_list_members/) for full documentation.
#'
#' @param maxResults The maximum number of items to include in each page of a paginated
#' response.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#' @param onlyAssociated Specifies which accounts to include in the response, based on the status
#' of an account's relationship with the administrator account. By default,
#' the response includes only current member accounts. To include all
#' accounts, set this value to false.
#'
#' @keywords internal
#'
#' @rdname macie2_list_members
macie2_list_members <- function(maxResults = NULL, nextToken = NULL, onlyAssociated = NULL) {
  op <- new_operation(
    name = "ListMembers",
    http_method = "GET",
    http_path = "/members",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "members"),
    stream_api = FALSE
  )
  input <- .macie2$list_members_input(maxResults = maxResults, nextToken = nextToken, onlyAssociated = onlyAssociated)
  output <- .macie2$list_members_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_members <- macie2_list_members

#' Retrieves information about the delegated Amazon Macie administrator
#' account for an organization in Organizations
#'
#' @description
#' Retrieves information about the delegated Amazon Macie administrator account for an organization in Organizations.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_organization_admin_accounts/](https://www.paws-r-sdk.com/docs/macie2_list_organization_admin_accounts/) for full documentation.
#'
#' @param maxResults The maximum number of items to include in each page of a paginated
#' response.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname macie2_list_organization_admin_accounts
macie2_list_organization_admin_accounts <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListOrganizationAdminAccounts",
    http_method = "GET",
    http_path = "/admin",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "adminAccounts"),
    stream_api = FALSE
  )
  input <- .macie2$list_organization_admin_accounts_input(maxResults = maxResults, nextToken = nextToken)
  output <- .macie2$list_organization_admin_accounts_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_organization_admin_accounts <- macie2_list_organization_admin_accounts

#' Retrieves information about objects that Amazon Macie selected from an
#' S3 bucket for automated sensitive data discovery
#'
#' @description
#' Retrieves information about objects that Amazon Macie selected from an S3 bucket for automated sensitive data discovery.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_resource_profile_artifacts/](https://www.paws-r-sdk.com/docs/macie2_list_resource_profile_artifacts/) for full documentation.
#'
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the S3 bucket that the request applies
#' to.
#'
#' @keywords internal
#'
#' @rdname macie2_list_resource_profile_artifacts
macie2_list_resource_profile_artifacts <- function(nextToken = NULL, resourceArn) {
  op <- new_operation(
    name = "ListResourceProfileArtifacts",
    http_method = "GET",
    http_path = "/resource-profiles/artifacts",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "artifacts"),
    stream_api = FALSE
  )
  input <- .macie2$list_resource_profile_artifacts_input(nextToken = nextToken, resourceArn = resourceArn)
  output <- .macie2$list_resource_profile_artifacts_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_resource_profile_artifacts <- macie2_list_resource_profile_artifacts

#' Retrieves information about the types and amount of sensitive data that
#' Amazon Macie found in an S3 bucket
#'
#' @description
#' Retrieves information about the types and amount of sensitive data that Amazon Macie found in an S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_resource_profile_detections/](https://www.paws-r-sdk.com/docs/macie2_list_resource_profile_detections/) for full documentation.
#'
#' @param maxResults The maximum number of items to include in each page of a paginated
#' response.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the S3 bucket that the request applies
#' to.
#'
#' @keywords internal
#'
#' @rdname macie2_list_resource_profile_detections
macie2_list_resource_profile_detections <- function(maxResults = NULL, nextToken = NULL, resourceArn) {
  op <- new_operation(
    name = "ListResourceProfileDetections",
    http_method = "GET",
    http_path = "/resource-profiles/detections",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "detections"),
    stream_api = FALSE
  )
  input <- .macie2$list_resource_profile_detections_input(maxResults = maxResults, nextToken = nextToken, resourceArn = resourceArn)
  output <- .macie2$list_resource_profile_detections_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_resource_profile_detections <- macie2_list_resource_profile_detections

#' Retrieves a subset of information about the sensitivity inspection
#' template for an account
#'
#' @description
#' Retrieves a subset of information about the sensitivity inspection template for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_sensitivity_inspection_templates/](https://www.paws-r-sdk.com/docs/macie2_list_sensitivity_inspection_templates/) for full documentation.
#'
#' @param maxResults The maximum number of items to include in each page of a paginated
#' response.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @keywords internal
#'
#' @rdname macie2_list_sensitivity_inspection_templates
macie2_list_sensitivity_inspection_templates <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSensitivityInspectionTemplates",
    http_method = "GET",
    http_path = "/templates/sensitivity-inspections",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "sensitivityInspectionTemplates"),
    stream_api = FALSE
  )
  input <- .macie2$list_sensitivity_inspection_templates_input(maxResults = maxResults, nextToken = nextToken)
  output <- .macie2$list_sensitivity_inspection_templates_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_sensitivity_inspection_templates <- macie2_list_sensitivity_inspection_templates

#' Retrieves the tags (keys and values) that are associated with an Amazon
#' Macie resource
#'
#' @description
#' Retrieves the tags (keys and values) that are associated with an Amazon Macie resource.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/macie2_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname macie2_list_tags_for_resource
macie2_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .macie2$list_tags_for_resource_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$list_tags_for_resource <- macie2_list_tags_for_resource

#' Adds or updates the configuration settings for storing data
#' classification results
#'
#' @description
#' Adds or updates the configuration settings for storing data classification results.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_put_classification_export_configuration/](https://www.paws-r-sdk.com/docs/macie2_put_classification_export_configuration/) for full documentation.
#'
#' @param configuration &#91;required&#93; The location to store data classification results in, and the encryption
#' settings to use when storing results in that location.
#'
#' @keywords internal
#'
#' @rdname macie2_put_classification_export_configuration
macie2_put_classification_export_configuration <- function(configuration) {
  op <- new_operation(
    name = "PutClassificationExportConfiguration",
    http_method = "PUT",
    http_path = "/classification-export-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$put_classification_export_configuration_input(configuration = configuration)
  output <- .macie2$put_classification_export_configuration_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$put_classification_export_configuration <- macie2_put_classification_export_configuration

#' Updates the configuration settings for publishing findings to Security
#' Hub
#'
#' @description
#' Updates the configuration settings for publishing findings to Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_put_findings_publication_configuration/](https://www.paws-r-sdk.com/docs/macie2_put_findings_publication_configuration/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive token that you provide to ensure the
#' idempotency of the request.
#' @param securityHubConfiguration The configuration settings that determine which findings to publish to
#' Security Hub.
#'
#' @keywords internal
#'
#' @rdname macie2_put_findings_publication_configuration
macie2_put_findings_publication_configuration <- function(clientToken = NULL, securityHubConfiguration = NULL) {
  op <- new_operation(
    name = "PutFindingsPublicationConfiguration",
    http_method = "PUT",
    http_path = "/findings-publication-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$put_findings_publication_configuration_input(clientToken = clientToken, securityHubConfiguration = securityHubConfiguration)
  output <- .macie2$put_findings_publication_configuration_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$put_findings_publication_configuration <- macie2_put_findings_publication_configuration

#' Retrieves (queries) statistical data and other information about Amazon
#' Web Services resources that Amazon Macie monitors and analyzes for an
#' account
#'
#' @description
#' Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie monitors and analyzes for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_search_resources/](https://www.paws-r-sdk.com/docs/macie2_search_resources/) for full documentation.
#'
#' @param bucketCriteria The filter conditions that determine which S3 buckets to include or
#' exclude from the query results.
#' @param maxResults The maximum number of items to include in each page of the response. The
#' default value is 50.
#' @param nextToken The nextToken string that specifies which page of results to return in a
#' paginated response.
#' @param sortCriteria The criteria to use to sort the results.
#'
#' @keywords internal
#'
#' @rdname macie2_search_resources
macie2_search_resources <- function(bucketCriteria = NULL, maxResults = NULL, nextToken = NULL, sortCriteria = NULL) {
  op <- new_operation(
    name = "SearchResources",
    http_method = "POST",
    http_path = "/datasources/search-resources",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "matchingResources"),
    stream_api = FALSE
  )
  input <- .macie2$search_resources_input(bucketCriteria = bucketCriteria, maxResults = maxResults, nextToken = nextToken, sortCriteria = sortCriteria)
  output <- .macie2$search_resources_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$search_resources <- macie2_search_resources

#' Adds or updates one or more tags (keys and values) that are associated
#' with an Amazon Macie resource
#'
#' @description
#' Adds or updates one or more tags (keys and values) that are associated with an Amazon Macie resource.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_tag_resource/](https://www.paws-r-sdk.com/docs/macie2_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; A map of key-value pairs that specifies the tags to associate with the
#' resource.
#' 
#' A resource can have a maximum of 50 tags. Each tag consists of a tag key
#' and an associated tag value. The maximum length of a tag key is 128
#' characters. The maximum length of a tag value is 256 characters.
#'
#' @keywords internal
#'
#' @rdname macie2_tag_resource
macie2_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .macie2$tag_resource_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$tag_resource <- macie2_tag_resource

#' Tests criteria for a custom data identifier
#'
#' @description
#' Tests criteria for a custom data identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_test_custom_data_identifier/](https://www.paws-r-sdk.com/docs/macie2_test_custom_data_identifier/) for full documentation.
#'
#' @param ignoreWords An array that lists specific character sequences (*ignore words*) to
#' exclude from the results. If the text matched by the regular expression
#' contains any string in this array, Amazon Macie ignores it. The array
#' can contain as many as 10 ignore words. Each ignore word can contain
#' 4-90 UTF-8 characters. Ignore words are case sensitive.
#' @param keywords An array that lists specific character sequences (*keywords*), one of
#' which must precede and be within proximity (maximumMatchDistance) of the
#' regular expression to match. The array can contain as many as 50
#' keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords
#' aren't case sensitive.
#' @param maximumMatchDistance The maximum number of characters that can exist between the end of at
#' least one complete character sequence specified by the keywords array
#' and the end of the text that matches the regex pattern. If a complete
#' keyword precedes all the text that matches the pattern and the keyword
#' is within the specified distance, Amazon Macie includes the result. The
#' distance can be 1-300 characters. The default value is 50.
#' @param regex &#91;required&#93; The regular expression (*regex*) that defines the pattern to match. The
#' expression can contain as many as 512 characters.
#' @param sampleText &#91;required&#93; The sample text to inspect by using the custom data identifier. The text
#' can contain as many as 1,000 characters.
#'
#' @keywords internal
#'
#' @rdname macie2_test_custom_data_identifier
macie2_test_custom_data_identifier <- function(ignoreWords = NULL, keywords = NULL, maximumMatchDistance = NULL, regex, sampleText) {
  op <- new_operation(
    name = "TestCustomDataIdentifier",
    http_method = "POST",
    http_path = "/custom-data-identifiers/test",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$test_custom_data_identifier_input(ignoreWords = ignoreWords, keywords = keywords, maximumMatchDistance = maximumMatchDistance, regex = regex, sampleText = sampleText)
  output <- .macie2$test_custom_data_identifier_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$test_custom_data_identifier <- macie2_test_custom_data_identifier

#' Removes one or more tags (keys and values) from an Amazon Macie resource
#'
#' @description
#' Removes one or more tags (keys and values) from an Amazon Macie resource.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_untag_resource/](https://www.paws-r-sdk.com/docs/macie2_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tagKeys &#91;required&#93; One or more tags (keys) to remove from the resource. In an HTTP request
#' to remove multiple tags, append the tagKeys parameter and argument for
#' each tag to remove, separated by an ampersand (&).
#'
#' @keywords internal
#'
#' @rdname macie2_untag_resource
macie2_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .macie2$untag_resource_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$untag_resource <- macie2_untag_resource

#' Updates the settings for an allow list
#'
#' @description
#' Updates the settings for an allow list.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_update_allow_list/](https://www.paws-r-sdk.com/docs/macie2_update_allow_list/) for full documentation.
#'
#' @param criteria &#91;required&#93; The criteria that specify the text or text pattern to ignore. The
#' criteria can be the location and name of an S3 object that lists
#' specific text to ignore (s3WordsList), or a regular expression that
#' defines a text pattern to ignore (regex).
#' 
#' You can change a list's underlying criteria, such as the name of the S3
#' object or the regular expression to use. However, you can't change the
#' type from s3WordsList to regex or the other way around.
#' @param description A custom description of the allow list. The description can contain as
#' many as 512 characters.
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#' @param name &#91;required&#93; A custom name for the allow list. The name can contain as many as 128
#' characters.
#'
#' @keywords internal
#'
#' @rdname macie2_update_allow_list
macie2_update_allow_list <- function(criteria, description = NULL, id, name) {
  op <- new_operation(
    name = "UpdateAllowList",
    http_method = "PUT",
    http_path = "/allow-lists/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$update_allow_list_input(criteria = criteria, description = description, id = id, name = name)
  output <- .macie2$update_allow_list_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$update_allow_list <- macie2_update_allow_list

#' Changes the configuration settings and status of automated sensitive
#' data discovery for an organization or standalone account
#'
#' @description
#' Changes the configuration settings and status of automated sensitive data discovery for an organization or standalone account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_update_automated_discovery_configuration/](https://www.paws-r-sdk.com/docs/macie2_update_automated_discovery_configuration/) for full documentation.
#'
#' @param autoEnableOrganizationMembers Specifies whether to automatically enable automated sensitive data
#' discovery for accounts in the organization. Valid values are: ALL
#' (default), enable it for all existing accounts and new member accounts;
#' NEW, enable it only for new member accounts; and, NONE, don't enable it
#' for any accounts.
#' 
#' If you specify NEW or NONE, automated sensitive data discovery continues
#' to be enabled for any existing accounts that it's currently enabled for.
#' To enable or disable it for individual member accounts, specify NEW or
#' NONE, and then enable or disable it for each account by using the
#' BatchUpdateAutomatedDiscoveryAccounts operation.
#' @param status &#91;required&#93; The new status of automated sensitive data discovery for the
#' organization or account. Valid values are: ENABLED, start or resume all
#' automated sensitive data discovery activities; and, DISABLED, stop
#' performing all automated sensitive data discovery activities.
#' 
#' If you specify DISABLED for an administrator account, you also disable
#' automated sensitive data discovery for all member accounts in the
#' organization.
#'
#' @keywords internal
#'
#' @rdname macie2_update_automated_discovery_configuration
macie2_update_automated_discovery_configuration <- function(autoEnableOrganizationMembers = NULL, status) {
  op <- new_operation(
    name = "UpdateAutomatedDiscoveryConfiguration",
    http_method = "PUT",
    http_path = "/automated-discovery/configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$update_automated_discovery_configuration_input(autoEnableOrganizationMembers = autoEnableOrganizationMembers, status = status)
  output <- .macie2$update_automated_discovery_configuration_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$update_automated_discovery_configuration <- macie2_update_automated_discovery_configuration

#' Changes the status of a classification job
#'
#' @description
#' Changes the status of a classification job.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_update_classification_job/](https://www.paws-r-sdk.com/docs/macie2_update_classification_job/) for full documentation.
#'
#' @param jobId &#91;required&#93; The unique identifier for the classification job.
#' @param jobStatus &#91;required&#93; The new status for the job. Valid values are:
#' 
#' -   CANCELLED - Stops the job permanently and cancels it. This value is
#'     valid only if the job's current status is IDLE, PAUSED, RUNNING, or
#'     USER_PAUSED.
#' 
#'     If you specify this value and the job's current status is RUNNING,
#'     Amazon Macie immediately begins to stop all processing tasks for the
#'     job. You can't resume or restart a job after you cancel it.
#' 
#' -   RUNNING - Resumes the job. This value is valid only if the job's
#'     current status is USER_PAUSED.
#' 
#'     If you paused the job while it was actively running and you specify
#'     this value less than 30 days after you paused the job, Macie
#'     immediately resumes processing from the point where you paused the
#'     job. Otherwise, Macie resumes the job according to the schedule and
#'     other settings for the job.
#' 
#' -   USER_PAUSED - Pauses the job temporarily. This value is valid only
#'     if the job's current status is IDLE, PAUSED, or RUNNING. If you
#'     specify this value and the job's current status is RUNNING, Macie
#'     immediately begins to pause all processing tasks for the job.
#' 
#'     If you pause a one-time job and you don't resume it within 30 days,
#'     the job expires and Macie cancels the job. If you pause a recurring
#'     job when its status is RUNNING and you don't resume it within 30
#'     days, the job run expires and Macie cancels the run. To check the
#'     expiration date, refer to the UserPausedDetails.jobExpiresAt
#'     property.
#'
#' @keywords internal
#'
#' @rdname macie2_update_classification_job
macie2_update_classification_job <- function(jobId, jobStatus) {
  op <- new_operation(
    name = "UpdateClassificationJob",
    http_method = "PATCH",
    http_path = "/jobs/{jobId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$update_classification_job_input(jobId = jobId, jobStatus = jobStatus)
  output <- .macie2$update_classification_job_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$update_classification_job <- macie2_update_classification_job

#' Updates the classification scope settings for an account
#'
#' @description
#' Updates the classification scope settings for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_update_classification_scope/](https://www.paws-r-sdk.com/docs/macie2_update_classification_scope/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#' @param s3 The S3 buckets to add or remove from the exclusion list defined by the
#' classification scope.
#'
#' @keywords internal
#'
#' @rdname macie2_update_classification_scope
macie2_update_classification_scope <- function(id, s3 = NULL) {
  op <- new_operation(
    name = "UpdateClassificationScope",
    http_method = "PATCH",
    http_path = "/classification-scopes/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$update_classification_scope_input(id = id, s3 = s3)
  output <- .macie2$update_classification_scope_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$update_classification_scope <- macie2_update_classification_scope

#' Updates the criteria and other settings for a findings filter
#'
#' @description
#' Updates the criteria and other settings for a findings filter.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_update_findings_filter/](https://www.paws-r-sdk.com/docs/macie2_update_findings_filter/) for full documentation.
#'
#' @param action The action to perform on findings that match the filter criteria
#' (findingCriteria). Valid values are: ARCHIVE, suppress (automatically
#' archive) the findings; and, NOOP, don't perform any action on the
#' findings.
#' @param clientToken A unique, case-sensitive token that you provide to ensure the
#' idempotency of the request.
#' @param description A custom description of the filter. The description can contain as many
#' as 512 characters.
#' 
#' We strongly recommend that you avoid including any sensitive data in the
#' description of a filter. Other users of your account might be able to
#' see this description, depending on the actions that they're allowed to
#' perform in Amazon Macie.
#' @param findingCriteria The criteria to use to filter findings.
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#' @param name A custom name for the filter. The name must contain at least 3
#' characters and can contain as many as 64 characters.
#' 
#' We strongly recommend that you avoid including any sensitive data in the
#' name of a filter. Other users of your account might be able to see this
#' name, depending on the actions that they're allowed to perform in Amazon
#' Macie.
#' @param position The position of the filter in the list of saved filters on the Amazon
#' Macie console. This value also determines the order in which the filter
#' is applied to findings, relative to other filters that are also applied
#' to the findings.
#'
#' @keywords internal
#'
#' @rdname macie2_update_findings_filter
macie2_update_findings_filter <- function(action = NULL, clientToken = NULL, description = NULL, findingCriteria = NULL, id, name = NULL, position = NULL) {
  op <- new_operation(
    name = "UpdateFindingsFilter",
    http_method = "PATCH",
    http_path = "/findingsfilters/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$update_findings_filter_input(action = action, clientToken = clientToken, description = description, findingCriteria = findingCriteria, id = id, name = name, position = position)
  output <- .macie2$update_findings_filter_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$update_findings_filter <- macie2_update_findings_filter

#' Suspends or re-enables Amazon Macie, or updates the configuration
#' settings for a Macie account
#'
#' @description
#' Suspends or re-enables Amazon Macie, or updates the configuration settings for a Macie account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_update_macie_session/](https://www.paws-r-sdk.com/docs/macie2_update_macie_session/) for full documentation.
#'
#' @param findingPublishingFrequency Specifies how often to publish updates to policy findings for the
#' account. This includes publishing updates to Security Hub and Amazon
#' EventBridge (formerly Amazon CloudWatch Events).
#' @param status Specifies a new status for the account. Valid values are: ENABLED,
#' resume all Amazon Macie activities for the account; and, PAUSED, suspend
#' all Macie activities for the account.
#'
#' @keywords internal
#'
#' @rdname macie2_update_macie_session
macie2_update_macie_session <- function(findingPublishingFrequency = NULL, status = NULL) {
  op <- new_operation(
    name = "UpdateMacieSession",
    http_method = "PATCH",
    http_path = "/macie",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$update_macie_session_input(findingPublishingFrequency = findingPublishingFrequency, status = status)
  output <- .macie2$update_macie_session_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$update_macie_session <- macie2_update_macie_session

#' Enables an Amazon Macie administrator to suspend or re-enable Macie for
#' a member account
#'
#' @description
#' Enables an Amazon Macie administrator to suspend or re-enable Macie for a member account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_update_member_session/](https://www.paws-r-sdk.com/docs/macie2_update_member_session/) for full documentation.
#'
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#' @param status &#91;required&#93; Specifies the new status for the account. Valid values are: ENABLED,
#' resume all Amazon Macie activities for the account; and, PAUSED, suspend
#' all Macie activities for the account.
#'
#' @keywords internal
#'
#' @rdname macie2_update_member_session
macie2_update_member_session <- function(id, status) {
  op <- new_operation(
    name = "UpdateMemberSession",
    http_method = "PATCH",
    http_path = "/macie/members/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$update_member_session_input(id = id, status = status)
  output <- .macie2$update_member_session_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$update_member_session <- macie2_update_member_session

#' Updates the Amazon Macie configuration settings for an organization in
#' Organizations
#'
#' @description
#' Updates the Amazon Macie configuration settings for an organization in Organizations.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_update_organization_configuration/](https://www.paws-r-sdk.com/docs/macie2_update_organization_configuration/) for full documentation.
#'
#' @param autoEnable &#91;required&#93; Specifies whether to enable Amazon Macie automatically for accounts that
#' are added to the organization in Organizations.
#'
#' @keywords internal
#'
#' @rdname macie2_update_organization_configuration
macie2_update_organization_configuration <- function(autoEnable) {
  op <- new_operation(
    name = "UpdateOrganizationConfiguration",
    http_method = "PATCH",
    http_path = "/admin/configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$update_organization_configuration_input(autoEnable = autoEnable)
  output <- .macie2$update_organization_configuration_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$update_organization_configuration <- macie2_update_organization_configuration

#' Updates the sensitivity score for an S3 bucket
#'
#' @description
#' Updates the sensitivity score for an S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_update_resource_profile/](https://www.paws-r-sdk.com/docs/macie2_update_resource_profile/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the S3 bucket that the request applies
#' to.
#' @param sensitivityScoreOverride The new sensitivity score for the bucket. Valid values are: 100, assign
#' the maximum score and apply the *Sensitive* label to the bucket; and,
#' null (empty), assign a score that Amazon Macie calculates automatically
#' after you submit the request.
#'
#' @keywords internal
#'
#' @rdname macie2_update_resource_profile
macie2_update_resource_profile <- function(resourceArn, sensitivityScoreOverride = NULL) {
  op <- new_operation(
    name = "UpdateResourceProfile",
    http_method = "PATCH",
    http_path = "/resource-profiles",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$update_resource_profile_input(resourceArn = resourceArn, sensitivityScoreOverride = sensitivityScoreOverride)
  output <- .macie2$update_resource_profile_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$update_resource_profile <- macie2_update_resource_profile

#' Updates the sensitivity scoring settings for an S3 bucket
#'
#' @description
#' Updates the sensitivity scoring settings for an S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_update_resource_profile_detections/](https://www.paws-r-sdk.com/docs/macie2_update_resource_profile_detections/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the S3 bucket that the request applies
#' to.
#' @param suppressDataIdentifiers An array of objects, one for each custom data identifier or managed data
#' identifier that detected a type of sensitive data to exclude from the
#' bucket's score. To include all sensitive data types in the score, don't
#' specify any values for this array.
#'
#' @keywords internal
#'
#' @rdname macie2_update_resource_profile_detections
macie2_update_resource_profile_detections <- function(resourceArn, suppressDataIdentifiers = NULL) {
  op <- new_operation(
    name = "UpdateResourceProfileDetections",
    http_method = "PATCH",
    http_path = "/resource-profiles/detections",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$update_resource_profile_detections_input(resourceArn = resourceArn, suppressDataIdentifiers = suppressDataIdentifiers)
  output <- .macie2$update_resource_profile_detections_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$update_resource_profile_detections <- macie2_update_resource_profile_detections

#' Updates the status and configuration settings for retrieving occurrences
#' of sensitive data reported by findings
#'
#' @description
#' Updates the status and configuration settings for retrieving occurrences of sensitive data reported by findings.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_update_reveal_configuration/](https://www.paws-r-sdk.com/docs/macie2_update_reveal_configuration/) for full documentation.
#'
#' @param configuration &#91;required&#93; The KMS key to use to encrypt the sensitive data, and the status of the
#' configuration for the Amazon Macie account.
#' @param retrievalConfiguration The access method and settings to use when retrieving the sensitive
#' data.
#'
#' @keywords internal
#'
#' @rdname macie2_update_reveal_configuration
macie2_update_reveal_configuration <- function(configuration, retrievalConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateRevealConfiguration",
    http_method = "PUT",
    http_path = "/reveal-configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$update_reveal_configuration_input(configuration = configuration, retrievalConfiguration = retrievalConfiguration)
  output <- .macie2$update_reveal_configuration_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$update_reveal_configuration <- macie2_update_reveal_configuration

#' Updates the settings for the sensitivity inspection template for an
#' account
#'
#' @description
#' Updates the settings for the sensitivity inspection template for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie2_update_sensitivity_inspection_template/](https://www.paws-r-sdk.com/docs/macie2_update_sensitivity_inspection_template/) for full documentation.
#'
#' @param description A custom description of the template. The description can contain as
#' many as 200 characters.
#' @param excludes The managed data identifiers to explicitly exclude (not use) when
#' performing automated sensitive data discovery.
#' 
#' To exclude an allow list or custom data identifier that's currently
#' included by the template, update the values for the
#' SensitivityInspectionTemplateIncludes.allowListIds and
#' SensitivityInspectionTemplateIncludes.customDataIdentifierIds
#' properties, respectively.
#' @param id &#91;required&#93; The unique identifier for the Amazon Macie resource that the request
#' applies to.
#' @param includes The allow lists, custom data identifiers, and managed data identifiers
#' to explicitly include (use) when performing automated sensitive data
#' discovery.
#'
#' @keywords internal
#'
#' @rdname macie2_update_sensitivity_inspection_template
macie2_update_sensitivity_inspection_template <- function(description = NULL, excludes = NULL, id, includes = NULL) {
  op <- new_operation(
    name = "UpdateSensitivityInspectionTemplate",
    http_method = "PUT",
    http_path = "/templates/sensitivity-inspections/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .macie2$update_sensitivity_inspection_template_input(description = description, excludes = excludes, id = id, includes = includes)
  output <- .macie2$update_sensitivity_inspection_template_output()
  config <- get_config()
  svc <- .macie2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie2$operations$update_sensitivity_inspection_template <- macie2_update_sensitivity_inspection_template
