% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanroomsml_operations.R
\name{cleanroomsml_create_training_dataset}
\alias{cleanroomsml_create_training_dataset}
\title{Defines the information necessary to create a training dataset}
\usage{
cleanroomsml_create_training_dataset(
  name,
  roleArn,
  trainingData,
  tags = NULL,
  description = NULL
)
}
\arguments{
\item{name}{[required] The name of the training dataset. This name must be unique in your
account and region.}

\item{roleArn}{[required] The ARN of the IAM role that Clean Rooms ML can assume to read the data
referred to in the \code{dataSource} field of each dataset.

Passing a role across AWS accounts is not allowed. If you pass a role
that isn't in your account, you get an \code{AccessDeniedException} error.}

\item{trainingData}{[required] An array of information that lists the Dataset objects, which specifies
the dataset type and details on its location and schema. You must
provide a role that has read access to these tables.}

\item{tags}{The optional metadata that you apply to the resource to help you
categorize and organize them. Each tag consists of a key and an optional
value, both of which you define.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50.
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8.
\item Maximum value length - 256 Unicode characters in UTF-8.
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case sensitive.
\item Do not use aws:, AWS:, or any upper or lowercase combination of such
as a prefix for keys as it is reserved for AWS use. You cannot edit
or delete tag keys with this prefix. Values can have this prefix. If
a tag value has aws as its prefix but the key does not, then Clean
Rooms ML considers it to be a user tag and will count against the
limit of 50 tags. Tags with only the key prefix of aws do not count
against your tags per resource limit.
}}

\item{description}{The description of the training dataset.}
}
\description{
Defines the information necessary to create a training dataset. In Clean Rooms ML, the \code{TrainingDataset} is metadata that points to a Glue table, which is read only during \code{AudienceModel} creation.

See \url{https://www.paws-r-sdk.com/docs/cleanroomsml_create_training_dataset/} for full documentation.
}
\keyword{internal}
