% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_update_filter}
\alias{guardduty_update_filter}
\title{Updates the filter specified by the filter name}
\usage{
guardduty_update_filter(
  DetectorId,
  FilterName,
  Description = NULL,
  Action = NULL,
  Rank = NULL,
  FindingCriteria = NULL
)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector that specifies the GuardDuty service where
you want to update a filter.

To find the \code{detectorId} in the current Region, see the Settings page in
the GuardDuty console, or run the
\code{\link[=guardduty_list_detectors]{list_detectors}} API.}

\item{FilterName}{[required] The name of the filter.}

\item{Description}{The description of the filter. Valid characters include alphanumeric
characters, and special characters such as hyphen, period, colon,
underscore, parentheses (\code{{ }}, \verb{[ ]}, and \verb{( )}), forward slash,
horizontal tab, vertical tab, newline, form feed, return, and
whitespace.

[ ]: R:\%20}

\item{Action}{Specifies the action that is to be applied to the findings that match
the filter.}

\item{Rank}{Specifies the position of the filter in the list of current filters.
Also specifies the order in which this filter is applied to the
findings.}

\item{FindingCriteria}{Represents the criteria to be used in the filter for querying findings.}
}
\description{
Updates the filter specified by the filter name.

See \url{https://www.paws-r-sdk.com/docs/guardduty_update_filter/} for full documentation.
}
\keyword{internal}
