% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlm_operations.R
\name{dlm_update_lifecycle_policy}
\alias{dlm_update_lifecycle_policy}
\title{Updates the specified lifecycle policy}
\usage{
dlm_update_lifecycle_policy(PolicyId, ExecutionRoleArn, State,
  Description, PolicyDetails)
}
\arguments{
\item{PolicyId}{[required] The identifier of the lifecycle policy.}

\item{ExecutionRoleArn}{The Amazon Resource Name (ARN) of the IAM role used to run the
operations specified by the lifecycle policy.}

\item{State}{The desired activation state of the lifecycle policy after creation.}

\item{Description}{A description of the lifecycle policy.}

\item{PolicyDetails}{The configuration of the lifecycle policy.

Target tags cannot be re-used across policies.}
}
\description{
Updates the specified lifecycle policy.
}
\section{Request syntax}{
\preformatted{svc$update_lifecycle_policy(
  PolicyId = "string",
  ExecutionRoleArn = "string",
  State = "ENABLED"|"DISABLED",
  Description = "string",
  PolicyDetails = list(
    ResourceTypes = list(
      "VOLUME"
    ),
    TargetTags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    Schedules = list(
      list(
        Name = "string",
        CopyTags = TRUE|FALSE,
        TagsToAdd = list(
          list(
            Key = "string",
            Value = "string"
          )
        ),
        CreateRule = list(
          Interval = 123,
          IntervalUnit = "HOURS",
          Times = list(
            "string"
          )
        ),
        RetainRule = list(
          Count = 123
        )
      )
    )
  )
)
}
}

\keyword{internal}
