% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_join_domain}
\alias{storagegateway_join_domain}
\title{Adds a file gateway to an Active Directory domain}
\usage{
storagegateway_join_domain(GatewayARN, DomainName, OrganizationalUnit,
  DomainControllers, UserName, Password)
}
\arguments{
\item{GatewayARN}{[required] The Amazon Resource Name (ARN) of the gateway. Use the \code{ListGateways}
operation to return a list of gateways for your account and region.}

\item{DomainName}{[required] The name of the domain that you want the gateway to join.}

\item{OrganizationalUnit}{The organizational unit (OU) is a container with an Active Directory
that can hold users, groups, computers, and other OUs and this parameter
specifies the OU that the gateway will join within the AD domain.}

\item{DomainControllers}{List of IPv4 addresses, NetBIOS names, or host names of your domain
server. If you need to specify the port number include it after the
colon (":"). For example, \code{mydc.mydomain.com:389}.}

\item{UserName}{[required] Sets the user name of user who has permission to add the gateway to the
Active Directory domain.}

\item{Password}{[required] Sets the password of the user who has permission to add the gateway to
the Active Directory domain.}
}
\description{
Adds a file gateway to an Active Directory domain. This operation is
only supported for file gateways that support the SMB file protocol.
}
\section{Request syntax}{
\preformatted{svc$join_domain(
  GatewayARN = "string",
  DomainName = "string",
  OrganizationalUnit = "string",
  DomainControllers = list(
    "string"
  ),
  UserName = "string",
  Password = "string"
)
}
}

\keyword{internal}
