% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_update_backup_plan}
\alias{backup_update_backup_plan}
\title{Updates an existing backup plan identified by its backupPlanId with the
input document in JSON format}
\usage{
backup_update_backup_plan(BackupPlanId, BackupPlan)
}
\arguments{
\item{BackupPlanId}{[required] Uniquely identifies a backup plan.}

\item{BackupPlan}{[required] Specifies the body of a backup plan. Includes a \code{BackupPlanName} and one
or more sets of \code{Rules}.}
}
\description{
Updates an existing backup plan identified by its \code{backupPlanId} with
the input document in JSON format. The new version is uniquely
identified by a \code{VersionId}.
}
\section{Request syntax}{
\preformatted{svc$update_backup_plan(
  BackupPlanId = "string",
  BackupPlan = list(
    BackupPlanName = "string",
    Rules = list(
      list(
        RuleName = "string",
        TargetBackupVaultName = "string",
        ScheduleExpression = "string",
        StartWindowMinutes = 123,
        CompletionWindowMinutes = 123,
        Lifecycle = list(
          MoveToColdStorageAfterDays = 123,
          DeleteAfterDays = 123
        ),
        RecoveryPointTags = list(
          "string"
        ),
        CopyActions = list(
          list(
            Lifecycle = list(
              MoveToColdStorageAfterDays = 123,
              DeleteAfterDays = 123
            ),
            DestinationBackupVaultArn = "string"
          )
        )
      )
    ),
    AdvancedBackupSettings = list(
      list(
        ResourceType = "string",
        BackupOptions = list(
          "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
