% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_describe_job}
\alias{s3control_describe_job}
\title{Retrieves the configuration parameters and status for a Batch Operations
job}
\usage{
s3control_describe_job(AccountId, JobId)
}
\arguments{
\item{AccountId}{[required]}

\item{JobId}{[required] The ID for the job whose information you want to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  Job = list(
    JobId = "string",
    ConfirmationRequired = TRUE|FALSE,
    Description = "string",
    JobArn = "string",
    Status = "Active"|"Cancelled"|"Cancelling"|"Complete"|"Completing"|"Failed"|"Failing"|"New"|"Paused"|"Pausing"|"Preparing"|"Ready"|"Suspended",
    Manifest = list(
      Spec = list(
        Format = "S3BatchOperations_CSV_20180820"|"S3InventoryReport_CSV_20161130",
        Fields = list(
          "Ignore"|"Bucket"|"Key"|"VersionId"
        )
      ),
      Location = list(
        ObjectArn = "string",
        ObjectVersionId = "string",
        ETag = "string"
      )
    ),
    Operation = list(
      LambdaInvoke = list(
        FunctionArn = "string"
      ),
      S3PutObjectCopy = list(
        TargetResource = "string",
        CannedAccessControlList = "private"|"public-read"|"public-read-write"|"aws-exec-read"|"authenticated-read"|"bucket-owner-read"|"bucket-owner-full-control",
        AccessControlGrants = list(
          list(
            Grantee = list(
              TypeIdentifier = "id"|"emailAddress"|"uri",
              Identifier = "string",
              DisplayName = "string"
            ),
            Permission = "FULL_CONTROL"|"READ"|"WRITE"|"READ_ACP"|"WRITE_ACP"
          )
        ),
        MetadataDirective = "COPY"|"REPLACE",
        ModifiedSinceConstraint = as.POSIXct(
          "2015-01-01"
        ),
        NewObjectMetadata = list(
          CacheControl = "string",
          ContentDisposition = "string",
          ContentEncoding = "string",
          ContentLanguage = "string",
          UserMetadata = list(
            "string"
          ),
          ContentLength = 123,
          ContentMD5 = "string",
          ContentType = "string",
          HttpExpiresDate = as.POSIXct(
            "2015-01-01"
          ),
          RequesterCharged = TRUE|FALSE,
          SSEAlgorithm = "AES256"|"KMS"
        ),
        NewObjectTagging = list(
          list(
            Key = "string",
            Value = "string"
          )
        ),
        RedirectLocation = "string",
        RequesterPays = TRUE|FALSE,
        StorageClass = "STANDARD"|"STANDARD_IA"|"ONEZONE_IA"|"GLACIER"|"INTELLIGENT_TIERING"|"DEEP_ARCHIVE",
        UnModifiedSinceConstraint = as.POSIXct(
          "2015-01-01"
        ),
        SSEAwsKmsKeyId = "string",
        TargetKeyPrefix = "string",
        ObjectLockLegalHoldStatus = "OFF"|"ON",
        ObjectLockMode = "COMPLIANCE"|"GOVERNANCE",
        ObjectLockRetainUntilDate = as.POSIXct(
          "2015-01-01"
        )
      ),
      S3PutObjectAcl = list(
        AccessControlPolicy = list(
          AccessControlList = list(
            Owner = list(
              ID = "string",
              DisplayName = "string"
            ),
            Grants = list(
              list(
                Grantee = list(
                  TypeIdentifier = "id"|"emailAddress"|"uri",
                  Identifier = "string",
                  DisplayName = "string"
                ),
                Permission = "FULL_CONTROL"|"READ"|"WRITE"|"READ_ACP"|"WRITE_ACP"
              )
            )
          ),
          CannedAccessControlList = "private"|"public-read"|"public-read-write"|"aws-exec-read"|"authenticated-read"|"bucket-owner-read"|"bucket-owner-full-control"
        )
      ),
      S3PutObjectTagging = list(
        TagSet = list(
          list(
            Key = "string",
            Value = "string"
          )
        )
      ),
      S3InitiateRestoreObject = list(
        ExpirationInDays = 123,
        GlacierJobTier = "BULK"|"STANDARD"
      ),
      S3PutObjectLegalHold = list(
        LegalHold = list(
          Status = "OFF"|"ON"
        )
      ),
      S3PutObjectRetention = list(
        BypassGovernanceRetention = TRUE|FALSE,
        Retention = list(
          RetainUntilDate = as.POSIXct(
            "2015-01-01"
          ),
          Mode = "COMPLIANCE"|"GOVERNANCE"
        )
      )
    ),
    Priority = 123,
    ProgressSummary = list(
      TotalNumberOfTasks = 123,
      NumberOfTasksSucceeded = 123,
      NumberOfTasksFailed = 123
    ),
    StatusUpdateReason = "string",
    FailureReasons = list(
      list(
        FailureCode = "string",
        FailureReason = "string"
      )
    ),
    Report = list(
      Bucket = "string",
      Format = "Report_CSV_20180820",
      Enabled = TRUE|FALSE,
      Prefix = "string",
      ReportScope = "AllTasks"|"FailedTasksOnly"
    ),
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    TerminationDate = as.POSIXct(
      "2015-01-01"
    ),
    RoleArn = "string",
    SuspendedDate = as.POSIXct(
      "2015-01-01"
    ),
    SuspendedCause = "string"
  )
)
}
}
\description{
Retrieves the configuration parameters and status for a Batch Operations
job. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/}{S3 Batch Operations} in
the \emph{Amazon Simple Storage Service Developer Guide}.

Related actions include:
\itemize{
\item \code{\link[=s3control_create_job]{create_job}}
\item \code{\link[=s3control_list_jobs]{list_jobs}}
\item \code{\link[=s3control_update_job_priority]{update_job_priority}}
\item \code{\link[=s3control_update_job_status]{update_job_status}}
}
}
\section{Request syntax}{
\preformatted{svc$describe_job(
  AccountId = "string",
  JobId = "string"
)
}
}

\keyword{internal}
