% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_abort_vault_lock}
\alias{glacier_abort_vault_lock}
\title{This operation aborts the vault locking process if the vault lock is not
in the Locked state}
\usage{
glacier_abort_vault_lock(accountId, vaultName)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID. This value must match the
AWS account ID associated with the credentials used to sign the request.
You can either specify an AWS account ID or optionally a single \'\code{-}\'
(hyphen), in which case Amazon Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you specify
your account ID, do not include any hyphens (\'-\') in the ID.}

\item{vaultName}{[required] The name of the vault.}
}
\description{
This operation aborts the vault locking process if the vault lock is not
in the \code{Locked} state. If the vault lock is in the \code{Locked} state when
this operation is requested, the operation returns an
\code{AccessDeniedException} error. Aborting the vault locking process
removes the vault lock policy from the specified vault.
}
\details{
A vault lock is put into the \code{InProgress} state by calling
InitiateVaultLock. A vault lock is put into the \code{Locked} state by
calling CompleteVaultLock. You can get the state of a vault lock by
calling GetVaultLock. For more information about the vault locking
process, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html}{Amazon Glacier Vault Lock}.
For more information about vault lock policies, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html}{Amazon Glacier Access Control with Vault Lock Policies}.

This operation is idempotent. You can successfully invoke this operation
multiple times, if the vault lock is in the \code{InProgress} state or if
there is no policy associated with the vault.
}
\section{Request syntax}{
\preformatted{svc$abort_vault_lock(
  accountId = "string",
  vaultName = "string"
)
}
}

\examples{
# The example aborts the vault locking process if the vault lock is not in
# the Locked state for the vault named examplevault.
\dontrun{svc$abort_vault_lock(
  accountId = "-",
  vaultName = "examplevault"
)}

}
\keyword{internal}
