% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_upload_archive}
\alias{glacier_upload_archive}
\title{This operation adds an archive to a vault}
\usage{
glacier_upload_archive(
  vaultName,
  accountId,
  archiveDescription = NULL,
  checksum = NULL,
  body = NULL
)
}
\arguments{
\item{vaultName}{[required] The name of the vault.}

\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
'\code{-}' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you use an
account ID, do not include any hyphens ('-') in the ID.}

\item{archiveDescription}{The optional description of the archive you are uploading.}

\item{checksum}{The SHA256 tree hash of the data being uploaded.}

\item{body}{The data to upload.}
}
\description{
This operation adds an archive to a vault. This is a synchronous operation, and for a successful upload, your data is durably persisted. Amazon S3 Glacier returns the archive ID in the \code{x-amz-archive-id} header of the response.

See \url{https://www.paws-r-sdk.com/docs/glacier_upload_archive/} for full documentation.
}
\keyword{internal}
