% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_acl}
\alias{s3_put_bucket_acl}
\title{Sets the permissions on an existing bucket using access control lists
(ACL)}
\usage{
s3_put_bucket_acl(
  ACL = NULL,
  AccessControlPolicy = NULL,
  Bucket,
  ContentMD5 = NULL,
  ChecksumAlgorithm = NULL,
  GrantFullControl = NULL,
  GrantRead = NULL,
  GrantReadACP = NULL,
  GrantWrite = NULL,
  GrantWriteACP = NULL,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{ACL}{The canned ACL to apply to the bucket.}

\item{AccessControlPolicy}{Contains the elements that set the ACL permissions for an object per
grantee.}

\item{Bucket}{[required] The bucket to which to apply the ACL.}

\item{ContentMD5}{The base64-encoded 128-bit MD5 digest of the data. This header must be
used as a message integrity check to verify that the request body was
not corrupted in transit. For more information, go to \href{https://www.ietf.org/rfc/rfc1864.txt}{RFC 1864.}

For requests made using the Amazon Web Services Command Line Interface
(CLI) or Amazon Web Services SDKs, this field is calculated
automatically.}

\item{ChecksumAlgorithm}{Indicates the algorithm used to create the checksum for the object when
using the SDK. This header will not provide any additional functionality
if not using the SDK. When sending this header, there must be a
corresponding \code{x-amz-checksum} or \code{x-amz-trailer} header sent.
Otherwise, Amazon S3 fails the request with the HTTP status code
\verb{400 Bad Request}. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.

If you provide an individual checksum, Amazon S3 ignores any provided
\code{ChecksumAlgorithm} parameter.}

\item{GrantFullControl}{Allows grantee the read, write, read ACP, and write ACP permissions on
the bucket.}

\item{GrantRead}{Allows grantee to list the objects in the bucket.}

\item{GrantReadACP}{Allows grantee to read the bucket ACL.}

\item{GrantWrite}{Allows grantee to create new objects in the bucket.

For the bucket and object owners of existing objects, also allows
deletions and overwrites of those objects.}

\item{GrantWriteACP}{Allows grantee to write the ACL for the applicable bucket.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
Sets the permissions on an existing bucket using access control lists (ACL). For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html}{Using ACLs}. To set the ACL of a bucket, you must have \code{WRITE_ACP} permission.

See \url{https://www.paws-r-sdk.com/docs/s3_put_bucket_acl/} for full documentation.
}
\keyword{internal}
