% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_delete_bucket_encryption}
\alias{s3_delete_bucket_encryption}
\title{This implementation of the DELETE action resets the default encryption
for the bucket as server-side encryption with Amazon S3 managed keys
(SSE-S3)}
\usage{
s3_delete_bucket_encryption(Bucket, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] The name of the bucket containing the server-side encryption
configuration to delete.

\strong{Directory buckets} - When you use this operation with a directory
bucket, you must use path-style requests in the format
\verb{https://s3express-control.region-code.amazonaws.com/bucket-name }.
Virtual-hosted-style requests aren't supported. Directory bucket names
must be unique in the chosen Zone (Availability Zone or Local Zone).
Bucket names must also follow the format
\code{ bucket-base-name--zone-id--x-s3} (for example,
\code{ DOC-EXAMPLE-BUCKET--usw2-az1--x-s3}). For information about bucket
naming restrictions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html}{Directory bucket naming rules}
in the \emph{Amazon S3 User Guide}}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the account ID that you
provide does not match the actual owner of the bucket, the request fails
with the HTTP status code \verb{403 Forbidden} (access denied).

For directory buckets, this header is not supported in this API
operation. If you specify this header, the request fails with the HTTP
status code \verb{501 Not Implemented}.}
}
\description{
This implementation of the DELETE action resets the default encryption for the bucket as server-side encryption with Amazon S3 managed keys (SSE-S3).

See \url{https://www.paws-r-sdk.com/docs/s3_delete_bucket_encryption/} for full documentation.
}
\keyword{internal}
