% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_refresh_cache}
\alias{storagegateway_refresh_cache}
\title{Refreshes the cached inventory of objects for the specified file share}
\usage{
storagegateway_refresh_cache(FileShareARN, FolderList = NULL, Recursive = NULL)
}
\arguments{
\item{FileShareARN}{[required] The Amazon Resource Name (ARN) of the file share you want to refresh.}

\item{FolderList}{A comma-separated list of the paths of folders to refresh in the cache.
The default is [\code{"/"}]. The default refreshes objects and folders at
the root of the Amazon S3 bucket. If \code{Recursive} is set to \code{true}, the
entire S3 bucket that the file share has access to is refreshed.

Do not include \code{/} when specifying folder names. For example, you would
specify \code{samplefolder} rather than \verb{samplefolder/}.}

\item{Recursive}{A value that specifies whether to recursively refresh folders in the
cache. The refresh includes folders that were in the cache the last time
the gateway listed the folder's contents. If this value set to \code{true},
each folder that is listed in \code{FolderList} is recursively updated.
Otherwise, subfolders listed in \code{FolderList} are not refreshed. Only
objects that are in folders listed directly under \code{FolderList} are found
and used for the update. The default is \code{true}.

Valid Values: \code{true} | \code{false}}
}
\description{
Refreshes the cached inventory of objects for the specified file share. This operation finds objects in the Amazon S3 bucket that were added, removed, or replaced since the gateway last listed the bucket's contents and cached the results. This operation does not import files into the S3 File Gateway cache storage. It only updates the cached inventory to reflect changes in the inventory of the objects in the S3 bucket. This operation is only supported in the S3 File Gateway types.

See \url{https://www.paws-r-sdk.com/docs/storagegateway_refresh_cache/} for full documentation.
}
\keyword{internal}
