% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{cloudwatchevents}
\alias{cloudwatchevents}
\title{Amazon CloudWatch Events}
\usage{
cloudwatchevents()
}
\description{
Amazon CloudWatch Events helps you to respond to state changes in your
AWS resources. When your resources change state, they automatically send
events into an event stream. You can create rules that match selected
events in the stream and route them to targets to take action. You can
also use rules to take action on a predetermined schedule. For example,
you can configure rules to:
\itemize{
\item Automatically invoke an AWS Lambda function to update DNS entries
when an event notifies you that Amazon EC2 instance enters the
running state.
\item Direct specific API records from AWS CloudTrail to an Amazon Kinesis
data stream for detailed analysis of potential security or
availability risks.
\item Periodically invoke a built-in target to create a snapshot of an
Amazon EBS volume.
}

For more information about the features of Amazon CloudWatch Events, see
the \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/events}{Amazon CloudWatch Events User Guide}.
}
\section{Operations}{

\tabular{ll}{
\link[=cloudwatchevents_delete_rule]{delete_rule} \tab Deletes the specified rule \cr
\link[=cloudwatchevents_describe_event_bus]{describe_event_bus} \tab Displays the external AWS accounts that are permitted to write events to your account using your account's event bus, and the associated policy\cr
\link[=cloudwatchevents_describe_rule]{describe_rule} \tab Describes the specified rule \cr
\link[=cloudwatchevents_disable_rule]{disable_rule} \tab Disables the specified rule \cr
\link[=cloudwatchevents_enable_rule]{enable_rule} \tab Enables the specified rule \cr
\link[=cloudwatchevents_list_rule_names_by_target]{list_rule_names_by_target} \tab Lists the rules for the specified target \cr
\link[=cloudwatchevents_list_rules]{list_rules} \tab Lists your Amazon CloudWatch Events rules \cr
\link[=cloudwatchevents_list_tags_for_resource]{list_tags_for_resource} \tab Displays the tags associated with a CloudWatch Events resource \cr
\link[=cloudwatchevents_list_targets_by_rule]{list_targets_by_rule} \tab Lists the targets assigned to the specified rule \cr
\link[=cloudwatchevents_put_events]{put_events} \tab Sends custom events to Amazon CloudWatch Events so that they can be matched to rules \cr
\link[=cloudwatchevents_put_permission]{put_permission} \tab Running PutPermission permits the specified AWS account or AWS organization to put events to your account's default \emph{event bus} \cr
\link[=cloudwatchevents_put_rule]{put_rule} \tab Creates or updates the specified rule \cr
\link[=cloudwatchevents_put_targets]{put_targets} \tab Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule \cr
\link[=cloudwatchevents_remove_permission]{remove_permission} \tab Revokes the permission of another AWS account to be able to put events to your default event bus \cr
\link[=cloudwatchevents_remove_targets]{remove_targets} \tab Removes the specified targets from the specified rule \cr
\link[=cloudwatchevents_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified CloudWatch Events resource \cr
\link[=cloudwatchevents_test_event_pattern]{test_event_pattern} \tab Tests whether the specified event pattern matches the provided event \cr
\link[=cloudwatchevents_untag_resource]{untag_resource} \tab Removes one or more tags from the specified CloudWatch Events resource
}
}

\examples{
\donttest{svc <- cloudwatchevents()
svc$delete_rule(
  Foo = 123
)}

}
