% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{ecrpublic}
\alias{ecrpublic}
\title{Amazon Elastic Container Registry Public}
\usage{
ecrpublic(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Elastic Container Registry Public (Amazon ECR Public) is a
managed container image registry service. Amazon ECR provides both
public and private registries to host your container images. You can use
the Docker CLI or your preferred client to push, pull, and manage
images. Amazon ECR provides a secure, scalable, and reliable registry
for your Docker or Open Container Initiative (OCI) images. Amazon ECR
supports public repositories with this API. For information about the
Amazon ECR API for private repositories, see \href{https://docs.aws.amazon.com/AmazonECR/latest/APIReference/Welcome.html}{Amazon Elastic Container Registry API Reference}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- ecrpublic(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.compute:ecrpublic_batch_check_layer_availability]{batch_check_layer_availability} \tab Checks the availability of one or more image layers that are within a repository in a public registry\cr
\link[paws.compute:ecrpublic_batch_delete_image]{batch_delete_image} \tab Deletes a list of specified images that are within a repository in a public registry\cr
\link[paws.compute:ecrpublic_complete_layer_upload]{complete_layer_upload} \tab Informs Amazon ECR that the image layer upload is complete for a specified public registry, repository name, and upload ID\cr
\link[paws.compute:ecrpublic_create_repository]{create_repository} \tab Creates a repository in a public registry\cr
\link[paws.compute:ecrpublic_delete_repository]{delete_repository} \tab Deletes a repository in a public registry\cr
\link[paws.compute:ecrpublic_delete_repository_policy]{delete_repository_policy} \tab Deletes the repository policy that's associated with the specified repository\cr
\link[paws.compute:ecrpublic_describe_images]{describe_images} \tab Returns metadata that's related to the images in a repository in a public registry\cr
\link[paws.compute:ecrpublic_describe_image_tags]{describe_image_tags} \tab Returns the image tag details for a repository in a public registry\cr
\link[paws.compute:ecrpublic_describe_registries]{describe_registries} \tab Returns details for a public registry\cr
\link[paws.compute:ecrpublic_describe_repositories]{describe_repositories} \tab Describes repositories that are in a public registry\cr
\link[paws.compute:ecrpublic_get_authorization_token]{get_authorization_token} \tab Retrieves an authorization token\cr
\link[paws.compute:ecrpublic_get_registry_catalog_data]{get_registry_catalog_data} \tab Retrieves catalog metadata for a public registry\cr
\link[paws.compute:ecrpublic_get_repository_catalog_data]{get_repository_catalog_data} \tab Retrieve catalog metadata for a repository in a public registry\cr
\link[paws.compute:ecrpublic_get_repository_policy]{get_repository_policy} \tab Retrieves the repository policy for the specified repository\cr
\link[paws.compute:ecrpublic_initiate_layer_upload]{initiate_layer_upload} \tab Notifies Amazon ECR that you intend to upload an image layer\cr
\link[paws.compute:ecrpublic_list_tags_for_resource]{list_tags_for_resource} \tab List the tags for an Amazon ECR Public resource\cr
\link[paws.compute:ecrpublic_put_image]{put_image} \tab Creates or updates the image manifest and tags that are associated with an image\cr
\link[paws.compute:ecrpublic_put_registry_catalog_data]{put_registry_catalog_data} \tab Create or update the catalog data for a public registry\cr
\link[paws.compute:ecrpublic_put_repository_catalog_data]{put_repository_catalog_data} \tab Creates or updates the catalog data for a repository in a public registry\cr
\link[paws.compute:ecrpublic_set_repository_policy]{set_repository_policy} \tab Applies a repository policy to the specified public repository to control access permissions\cr
\link[paws.compute:ecrpublic_tag_resource]{tag_resource} \tab Associates the specified tags to a resource with the specified resourceArn\cr
\link[paws.compute:ecrpublic_untag_resource]{untag_resource} \tab Deletes specified tags from a resource\cr
\link[paws.compute:ecrpublic_upload_layer_part]{upload_layer_part} \tab Uploads an image layer part to Amazon ECR
}
}

\examples{
\dontrun{
svc <- ecrpublic()
svc$batch_check_layer_availability(
  Foo = 123
)
}

}
