% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{ebs}
\alias{ebs}
\title{Amazon Elastic Block Store}
\usage{
ebs(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
You can use the Amazon Elastic Block Store (Amazon EBS) direct APIs to
create Amazon EBS snapshots, write data directly to your snapshots, read
data on your snapshots, and identify the differences or changes between
two snapshots. If you’re an independent software vendor (ISV) who offers
backup services for Amazon EBS, the EBS direct APIs make it more
efficient and cost-effective to track incremental changes on your Amazon
EBS volumes through snapshots. This can be done without having to create
new volumes from snapshots, and then use Amazon Elastic Compute Cloud
(Amazon EC2) instances to compare the differences.

You can create incremental snapshots directly from data on-premises into
volumes and the cloud to use for quick disaster recovery. With the
ability to write and read snapshots, you can write your on-premises data
to an snapshot during a disaster. Then after recovery, you can restore
it back to Amazon Web Services or on-premises from the snapshot. You no
longer need to build and maintain complex mechanisms to copy data to and
from Amazon EBS.

This API reference provides detailed information about the actions, data
types, parameters, and errors of the EBS direct APIs. For more
information about the elements that make up the EBS direct APIs, and
examples of how to use them effectively, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html}{Accessing the Contents of an Amazon EBS Snapshot}
in the \emph{Amazon Elastic Compute Cloud User Guide}. For more information
about the supported Amazon Web Services Regions, endpoints, and service
quotas for the EBS direct APIs, see \href{https://docs.aws.amazon.com/general/latest/gr/ebs-service.html}{Amazon Elastic Block Store Endpoints and Quotas}
in the \emph{Amazon Web Services General Reference}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- ebs(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.storage:ebs_complete_snapshot]{complete_snapshot} \tab Seals and completes the snapshot after all of the required blocks of data have been written to it\cr
\link[paws.storage:ebs_get_snapshot_block]{get_snapshot_block} \tab Returns the data in a block in an Amazon Elastic Block Store snapshot\cr
\link[paws.storage:ebs_list_changed_blocks]{list_changed_blocks} \tab Returns information about the blocks that are different between two Amazon Elastic Block Store snapshots of the same volume/snapshot lineage\cr
\link[paws.storage:ebs_list_snapshot_blocks]{list_snapshot_blocks} \tab Returns information about the blocks in an Amazon Elastic Block Store snapshot\cr
\link[paws.storage:ebs_put_snapshot_block]{put_snapshot_block} \tab Writes a block of data to a snapshot\cr
\link[paws.storage:ebs_start_snapshot]{start_snapshot} \tab Creates a new Amazon EBS snapshot
}
}

\examples{
\dontrun{
svc <- ebs()
svc$complete_snapshot(
  Foo = 123
)
}

}
